<?php
/*+********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *********************************************************************************/

header('Pragma: public');
header('Expires: 0');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Cache-Control: private', false);

//Opensource fix for tracking email access count
// chdir(dirname(__FILE__). '/../../../');

require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

class Test_RoundRobin extends Vtiger_Action_Controller {

	public function process(Vtiger_Request $request) {
		global $adb;
		// $campaignid = 15447; // tiene round robin
		$campaignid = $request->get('id');
		$unidad = $request->get('tipo');
		// $adb->setDebug(true);
		$userid = $this->getUserIdRoundRobin($campaignid, $unidad);
		echo "<pre>";
		var_dump("Asignar a: ".$userid);
	}

	/*
	Henry Creantis: roundrobin
	*/
	public function getUserIdRoundRobin($campaignid, $unidad) {
	    global $adb;
	    $field_asignar_a = "cf_1001";

	    $rs = $adb->pquery("SELECT $field_asignar_a, roundrobin_userid, roundrobin_logic, smownerid 
	    	FROM vtiger_campaignscf cf 
	    	inner join vtiger_crmentity e on cf.campaignid = e.crmid and e.deleted = 0
	    	where cf.campaignid = ?", array($campaignid));
	    $data = array_map("decode_html", $adb->query_result_rowdata($rs));

	    $smownerid = $data['smownerid'];

	    if ( !empty($data["roundrobin_userid"]) ) {
		    $roundrobin_logic = json_decode($data["roundrobin_logic"],true);
		    $useridList = json_decode($data["roundrobin_userid"],true);

		    if ( isset($roundrobin_logic[$unidad]) ) {
			    $roundrobin_logic_unidad = $roundrobin_logic[$unidad];
			    
			    if($roundrobin_logic_unidad >= count($useridList))
			        $roundrobin_logic_unidad=0;

			    $roundrobinOwnerId = $useridList[$unidad][$roundrobin_logic_unidad];
			    $nextRoundrobinLogic = ($roundrobin_logic_unidad+1)%count($useridList[$unidad]);
			    $roundrobin_logic[$unidad] = $nextRoundrobinLogic;
			    
			    $roundrobin_logic = (object) $roundrobin_logic;
				$roundrobin_logic = json_encode($roundrobin_logic);

			    $adb->pquery("UPDATE vtiger_campaignscf SET roundrobin_logic = ? WHERE campaignid = ?", array($roundrobin_logic, $campaignid));
			    return vtlib_purify($roundrobinOwnerId);
		    } else {
	    		// En caso no tenga configurados los usuarios para la unidad de round robin, retorna el usuario asignado a la campaña
		    	return $smownerid;
		    }
	    } else {
	    	// En caso no tenga configurados los usuarios de round robin, retorna el usuario asignado a la campaña
	    	return $smownerid;
	    }
	}

}

$track = new Test_RoundRobin();
$track->process(new Vtiger_Request($_REQUEST));
