<?php
/*+********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *********************************************************************************/
ini_set('error_log','cliengo/cliengo_log.txt');
header('Pragma: public');
header('Expires: 0');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Cache-Control: private', false);

//Opensource fix for tracking email access count
chdir(dirname(__FILE__)."/../");
require_once 'data/CRMEntity.php';
include_once 'includes/main/WebUI.php';
include_once 'vtlib/Vtiger/Module.php';
require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

require_once("modules/Emails/mail.php");

define("API_KEY", "75049023-b20e-4ea3-9bfa-aad14061d8c5");
define("WEBHOOK_KEY_LEASING", "8fca971a-6ae9-46a0-8902-6024c82629b4");
define("WEBHOOK_KEY_FACTORING", "4e33f98a-0219-45ad-a99e-42a36e9152f1");
define("WEBHOOK_KEY_FB", "717d8bf2-f6a9-436c-a957-c1773a12e983");

class Cliengo_Webhook extends Vtiger_Action_Controller {
// Bluehost ticket http 406: 25642037 
	protected $message;
	public function setMessage($message) {
		$message = explode("\n", $message);
		$this->message = $message;
	}
	public function getMessage() {
		return $this->message;
	}
	
	public function process(Vtiger_Request $request) {
		global $adb, $current_user,$HELPDESK_SUPPORT_EMAIL_ID, $HELPDESK_SUPPORT_NAME, $curtime, $ACCESS_TOKEN;
		
		$current_user = Users::getActiveAdminUser();

		$input = json_decode($this->captureInput(), true); // cuando viene de cliengo
		//$input = json_decode($this->getTestJson(), true); // para hacer pruebas
		//echo "<pre>";
		//var_dump($input);
		//die();
		$this->setMessage($input['message']);

		if ( $this->isOriginChatbot($input) ) {
			$accountid = $this->validarCuenta($input);
			$contactid = $this->validarContacto($accountid, $input);
			$potentialid = $this->validarOportunidad($accountid, $contactid, $input);
			$result = array('accountid' => $accountid, 'contactid' => $contactid, 'potentialid' => $potentialid, "request" => $input);
		} else {
			$result = array('message' => "Origen desconocido", "request" => $input);
		}
		echo json_encode($result);
	}
	public function getUserByUnidad($unidad) {
		global $adb, $current_user;
		$rol = '';
		if ( $unidad == 'Leasing' ) {
			$rol = "H10"; // supervisor leasing
		} else if ( $unidad == 'Factoring' ) {
			$rol = "H9"; // supervisor factoring
		}

		$userid = $current_user->id;
		//$unidad ="Factoring";
		if ( !empty($rol) ) {

			//Obtenemos los usuarios que cumplan con unidad y se le hallan asignado Cliengo
			$rs = $adb->pquery("SELECT u.id FROM vtiger_users u 
					where  u.status = 'Active' and u.deleted = 0 and (u.unidad = ? or u.unidad = 'Leasing |##| Factoring') and u.recibe_lead = 'Cliengo'
					order by u.id asc", array($unidad));
			//Recorremos con un for para alascmancenar en un array los usuarios asignados 
			//$rsnum = $adb->num_rows($rs);
			$UsuariosPermitidos = array();

			//Obtenemos los usuarios permitidos para esta operación
			for ($i=0 ; $i < $adb->num_rows($rs); $i++){
				//$filas = array();
				//$filas["id"] = $adb->query_result($rs,$i,'id');
				$UsuariosPermitidos[] = $adb->query_result($rs,$i,'id');
			}

			//Validamos si hay usuarios sino se lo asginamos al admin
			if($adb->num_rows($rs) > 0 ){
				//Si hay usuarios recorremos la lista
				//Ahora obtendremos la ultima oportunidad para ver por quien fue antendia
				$potentials = $adb->pquery("SELECT  e.smownerid FROM vtiger_potential p 
						inner join vtiger_crmentity e on p.potentialid = e.crmid
						where  p.potentialname = ? and e.source = 'CLIENGO'
						order by p.potentialid desc limit 1", array($unidad));

				//Almacenamos las oportunidades atendidas
				$oportunidadesAtendidas = array();
				$respuesta = "";
				$proceso = "";
				for ($i=0 ; $i < $adb->num_rows($rs); $i++){
					//$filas = array();
					//$filas["id"] = $adb->query_result($rs,$i,'id');
					$opt =  $adb->query_result($potentials,0,'smownerid');

					if( $opt == $UsuariosPermitidos[$i]){
						//if()
							$respuesta = $UsuariosPermitidos[$i+1];
							break;
					}
				}

				if($respuesta == null || $respuesta == "null"){
					$respuesta = $UsuariosPermitidos[0];
				}

			$userid = $respuesta;
			}else{
				//Sino hay usuarios se lo asignamos al admin
				$userid = "1";
			}
			
		}

		return $userid;
	}
	public function validarCuenta($input) {
		global $adb, $current_user;
		$userid = $current_user->id;

		if ( $input['webhookKey'] == WEBHOOK_KEY_FACTORING ) {
			$tipo = "Factoring";
		} else if ( $input['webhookKey'] == WEBHOOK_KEY_LEASING || $input['webhookKey'] == WEBHOOK_KEY_FB ) {
			// H10 = Supervisor Comercial Leasing, cuando viene de FB se asigna a leasing
			// Los de FB también van a Leasing
			$tipo = "Leasing";
		}
		$userid = $this->getUserByUnidad( $tipo );

		$email = $input['email'];
		$nombres = $input['name'];
		$nombre = '';
		$apellido = $nombres;
		if ( count(explode(" ", $nombres)) > 1 ) {
			$arr = explode(" ", $nombres);
			$nombre = $arr[0];
			unset($arr[0]);
			$apellido = implode(" ", $arr);
		}
		$model = Vtiger_Record_Model::getCleanInstance("Accounts");
		$model->set('mode', "");
		$model->set('cf_852', "Persona Natural");
		$model->set('siccode', "POR COMPLETAR ".$email);
		$model->set('cf_908', $nombre);
		$model->set('cf_910', $apellido);
		$model->set('accountname', $nombres);
		$model->set('leadsource', 'Chatbot');
		$model->set('accounttype', 'Nuevo');
		$model->set('bill_country', '2168'); // Ubigeo: POR COMPLETAR
		$model->set('source', 'CLIENGO');
		$model->set('assigned_user_id', $userid);
		try {
			$model->save("Accounts");
			return $model->getId();
		} catch (Exception $e) {
			return null;
		}
	}
	public function validarContacto($accountid, $input) {
		global $adb, $current_user;
		$userid = $current_user->id;
		
		if ( $input['webhookKey'] == WEBHOOK_KEY_FACTORING ) {
			$tipo = "Factoring";
		} else if ( $input['webhookKey'] == WEBHOOK_KEY_LEASING || $input['webhookKey'] == WEBHOOK_KEY_FB ) {
			// H10 = Supervisor Comercial Leasing, cuando viene de FB se asigna a leasing
			// Los de FB también van a Leasing
			$tipo = "Leasing";
		}
		$userid = $this->getUserByUnidad( $tipo );

		$email = $input['email'];
		$contactid = null;
		// Busca el contacto relacionado 
		if ( !empty($accountid) ) {
			$rs = $adb->pquery("SELECT * FROM vtiger_contactdetails c 
				inner join vtiger_crmentity e on c.contactid = e.crmid and e.deleted = 0
				where c.accountid = ? and c.email = ? order by c.contactid desc limit 1", array($accountid, $email ));
			$contactid = '';
			if ( $adb->num_rows($rs) == 1 ) {
				$contactid = $adb->query_result($rs, 0, 'contactid');
			}
		}

		if ( empty($contactid) ) {
			// En caso no se haya creado el contacto con el workflow, pues aquí lo creamos ya que es necesario guardar su información
			$mobile = $input['phone'];
			$nombres = $input['name'];
			$nombre = '';
			$apellido = $nombres;
			if ( count(explode(" ", $nombres)) > 1 ) {
				$arr = explode(" ", $nombres);
				$nombre = $arr[0];
				unset($arr[0]);
				$apellido = implode(" ", $arr);
			}
			$model = Vtiger_Record_Model::getCleanInstance("Contacts");
			$model->set('mode', "");
			$model->set('firstname', $nombre);
			$model->set('lastname', $apellido);
			$model->set('mobile', $mobile);
			if ( !empty($accountid) ) {
				$model->set('account_id', $accountid);
			}
			$model->set('email', $email);
			$model->set('source', 'CLIENGO');
			$model->set('assigned_user_id', $userid);
			try {
				$model->save("Contacts");
				return $model->getId();
			} catch (Exception $e) {
				return null;
			}
		}
	}
	public function validarOportunidad($accountid, $contactid, $input) {
		global $adb, $current_user;
		$userid = $current_user->id;

		if ( $input['webhookKey'] == WEBHOOK_KEY_FACTORING ) {
			$tipo = "Factoring";
		} else if ( $input['webhookKey'] == WEBHOOK_KEY_LEASING || $input['webhookKey'] == WEBHOOK_KEY_FB ) {
			// H10 = Supervisor Comercial Leasing, cuando viene de FB se asigna a leasing
			// Los de FB también van a Leasing
			$tipo = "Leasing";
		}
		$userid = $this->getUserByUnidad( $tipo );

		$nombres = $input['name'];
		$nombre = '';
		$apellido = $nombres;
		if ( count(explode(" ", $nombres)) > 1 ) {
			$arr = explode(" ", $nombres);
			$nombre = $arr[0];
			unset($arr[0]);
			$apellido = implode(" ", $arr);
		}

		$fecha = new Datetime();
		$fecha->setTimezone(new DateTimeZone("America/Lima"));
		$dias = 7;
		if ( $tipo == 'Leasing' ) {
			$dias = 30;
		} else if ( $tipo == 'Factoring' ) {
			$dias = 7;
		}
		$fecha->modify("+$dias days");
		$fecha_estimada_cierre = $fecha->format("Y-m-d");

		$model = Vtiger_Record_Model::getCleanInstance("Potentials");
		$model->set('mode', "");
		$model->set('potentialname', $tipo);
		$model->set('related_to', $accountid);
		$model->set('contact_id', $contactid);
		$model->set('opportunity_type', $tipo);
		$model->set('closingdate', $fecha_estimada_cierre);
		$model->set('sales_stage', "Lead Nuevo");
		$model->set('leadsource', 'Chatbot');
		$model->set('description', $input['message']);
		$model->set('source', 'CLIENGO');
		$model->set('assigned_user_id', $userid);
		try {
			$model->save("Potentials");
			return $model->getId();
		} catch (Exception $e) {
			return null;
		}
	}

	public function getInputParam($param) {
		// Preguntas que hace el "asesor" (BOT)
		$params = array(
			"name" => 'Sera un placer asistirte, cual es su nombre?',
			"mobile" => 'podrías dejarme tu teléfono completo?',
			"email" => 'podrías dejarme tu email?',
			"horario" => 'A que hora del día prefieres que te llamemos?',
			"aditional_description" => 'quieres dejarme alguna consulta adicional?',
		);
		$index = array_search($params[ $param ], $this->message);
		$value = '';
		if ( $index >= 0 ) {
			$index++;
			$value = trim($this->message[$index]);
		}
		return $value;
	}
	
	public function isOriginChatbot($input) {
			if ( $input['webhookKey'] == WEBHOOK_KEY_LEASING || $input['webhookKey'] == WEBHOOK_KEY_FACTORING || $input['webhookKey'] == WEBHOOK_KEY_FB) {
				return true;
			}
		// if ( $input['entryMethod']=='CHATBOT' ) {
		// }
		return false;
	}

	public function captureInput(){
		global $curtime;
		//para capturar un nuevo lead
		//getTestJson();
		error_log(print_r( "[$curtime]===========captureInput=====================" , true));
		$lead_content = file_get_contents('php://input');
		$lead_content = !empty($lead_content) ? $lead_content : "";
		error_log(print_r( "[$curtime]===========JSON lead input=====================" , true));
		error_log(print_r($lead_content, true));
		return $lead_content;
	}

	public function getTestJson() {
		$json = '{
			"id": "5f59322776554600239d7c25",
			"accountId": "5e29a3c0e4b0b65c0e6bf51c",
			"websiteId": "5ebda3d2b873210028328220",
			"status": "new",
			"name": "cely bances",
			"email": "cbancess@hotmail.com",
			"phone": "986 314 575",
			"internationalPhoneNumber": "+51986314575",
			"whatsappPhoneNumber": "51986314575",
			"creationDate": "2020-09-09T19:51:03.358Z",
			"lastUpdateDate": "Sep 9, 2020 7:54:42 PM",
			"lastName": "bances",
			"age": 0,
			"webhookKey": "8fca971a-6ae9-46a0-8902-6024c82629b4",
			"ip": "190.233.207.33",
			"conversionUrl": "https://www.leasingtotal.com.pe/",
			"message": "cliente: HOLA buenas tardes\nasesor: Sera un placer asistirte, cual es su nombre?\ncliente: cely bances\nasesor:  yo me encargo de ponerte en contacto con un asesor para que responda tu consulta\nasesor: podrías dejarme tu teléfono completo?\ncliente: 986314575  cely bances\nasesor: podrías dejarme tu email?\ncliente: cbancess@hotmail.com\nasesor: A que hora del día prefieres que te llamemos?\ncliente: por las mañanas plan 10 am\nasesor: quieres dejarme alguna consulta adicional?\ncliente: si claro\nasesor:  Muchas gracias, con esta información un asesor se comunicará contigo a la brevedad.\ncliente: tengo entendido que leasing dar creditos para compra de un inmueble o bienes ,... la pregnta es tengo que ser persona natural o juridica?\nasesor: Somos una empresa de arrendamiento financiero con más de 20 años en el mercado. Nos especializamos en Maquinaria y Vehículos!\ncliente: tengo un negocio de transporte personal y necesito comprar un bus, leasing ouede gestionar la compra del vehiculo?\nasesor: Somos una empresa de arrendamiento financiero con más de 20 años en el mercado. Nos especializamos en Maquinaria y Vehículos!\ncliente: mi v ehiculo que necesito comprar es un bus de transporte personal\nasesor: Bien, me contacto con el asesor y le doy toda esta información. Muchas gracias por comunicarte!\ncliente: gracias   buenas tardes\nasesor: \n",
			"geoip": {
				"latitude": "-12.0432",
				"longitude": "-77.0282",
				"country": "PE",
				"state": "Lima",
				"city": "Lima",
				"zipCode": "15001"
			},
			"duplicatedContact": false,
			"notes": [],
			"logs": [],
			"calls": [],
			"medium": "none",
			"mediumTranslate": "Ninguno",
			"customParams": {
				"conversationId": "5f59307c54718c56cbcbd9e0",
				"contact_time": "por las mañanas plan 10 am",
				"firedTriggers[0]": "5ebdb74fccefca0028e5d638",
				"channel": "CHATBOT",
				"firedTriggers[1]": "5ebdb74fccefca0028e5d638",
				"body": "contact_time\u003dpor%20las%20ma%C3%B1anas%20plan%2010%20am\u0026final_question\u003dsi%20claro\u0026phoneVerified\u003d\u0026contactDni\u003d\u0026ldkCompanyId\u003d5e29a3c0e4b0b65c0e6bf51c\u0026ldkWebsiteId\u003d5ebda3d2b873210028328220\u0026ldkUtms\u003d\u0026conversationId\u003d5f59307c54718c56cbcbd9e0\u0026chatSessionId\u003d5f59307c54718c56cbcbd9e0\u0026firedTriggers%5B0%5D\u003d5ebdb74fccefca0028e5d638\u0026firedTriggers%5B1%5D\u003d5ebdb74fccefca0028e5d638\u0026channel\u003dCHATBOT\u0026chatUrl\u003dhttps%3A%2F%2Fwww.leasingtotal.com.pe%2F\u0026chatIp\u003d190.233.207.33\u0026chatLog\u003dcliente%3A%20HOLA%20buenas%20tardes%0Aasesor%3A%20Sera%20un%20placer%20asistirte%2C%20cual%20es%20su%20nombre%3F%0Acliente%3A%20cely%20bances%0Aasesor%3A%20%20yo%20me%20encargo%20de%20ponerte%20en%20contacto%20con%20un%20asesor%20para%20que%20responda%20tu%20consulta%0Aasesor%3A%20podr%C3%ADas%20dejarme%20tu%20tel%C3%A9fono%20completo%3F%0Acliente%3A%20986314575%20%20cely%20bances%0Aasesor%3A%20podr%C3%ADas%20dejarme%20tu%20email%3F%0Acliente%3A%20cbancess%40hotmail.com%0Aasesor%3A%20A%20que%20hora%20del%20d%C3%ADa%20prefieres%20que%20te%20llamemos%3F%0Acliente%3A%20por%20las%20ma%C3%B1anas%20plan%2010%20am%0Aasesor%3A%20quieres%20dejarme%20alguna%20consulta%20adicional%3F%0Acliente%3A%20si%20claro%0Aasesor%3A%20%20Muchas%20gracias%2C%20con%20esta%20informaci%C3%B3n%20un%20asesor%20se%20comunicar%C3%A1%20contigo%20a%20la%20brevedad.%0Acliente%3A%20tengo%20entendido%20que%20leasing%20dar%20creditos%20para%20compra%20de%20un%20inmueble%20o%20bienes%20%2C...%20la%20pregnta%20es%20tengo%20que%20ser%20persona%20natural%20o%20juridica%3F%0Aasesor%3A%20Somos%20una%20empresa%20de%20arrendamiento%20financiero%20con%20m%C3%A1s%20de%2020%20a%C3%B1os%20en%20el%20mercado.%20Nos%20especializamos%20en%20Maquinaria%20y%20Veh%C3%ADculos%21%0Acliente%3A%20tengo%20un%20negocio%20de%20transporte%20personal%20y%20necesito%20comprar%20un%20bus%2C%20leasing%20ouede%20gestionar%20la%20compra%20del%20vehiculo%3F%0Aasesor%3A%20Somos%20una%20empresa%20de%20arrendamiento%20financiero%20con%20m%C3%A1s%20de%2020%20a%C3%B1os%20en%20el%20mercado.%20Nos%20especializamos%20en%20Maquinaria%20y%20Veh%C3%ADculos%21%0Acliente%3A%20mi%20v%20ehiculo%20que%20necesito%20comprar%20es%20un%20bus%20de%20transporte%20personal%0Aasesor%3A%20Bien%2C%20me%20contacto%20con%20el%20asesor%20y%20le%20doy%20toda%20esta%20informaci%C3%B3n.%20Muchas%20gracias%20por%20comunicarte%21%0Acliente%3A%20gracias%20%20%20buenas%20tardes%0Aasesor%3A%20%0A\u0026chatName\u003d\u0026chatEmail\u003dcbancess%40hotmail.com\u0026chatPhone\u003d986%20314%20575\u0026chatInternationalPhone\u003d%2B51986314575\u0026chatIdNumber\u003d\u0026tags%5B0%5D\u003dfired_new_lead\u0026tags%5B1%5D\u003dask_feedback_sent\u0026tags%5B2%5D\u003dposted_email\u0026tags%5B3%5D\u003dposted_phone\u0026tags%5B4%5D\u003dposted_international_phone\u0026chatLeadFields%5Bcontact_time%5D\u003dpor%20las%20ma%C3%B1anas%20plan%2010%20am\u0026chatLeadFields%5Bfinal_question%5D\u003dsi%20claro",
				"tags[4]": "posted_international_phone",
				"ldkWebsiteId": "5ebda3d2b873210028328220",
				"ldkCompanyId": "5e29a3c0e4b0b65c0e6bf51c",
				"tags[1]": "ask_feedback_sent",
				"final_question": "si claro",
				"tags[0]": "fired_new_lead",
				"tags[3]": "posted_phone",
				"tags[2]": "posted_email"
			},
			"rating": 0,
			"conversationId": "5f59307c54718c56cbcbd9e0",
			"utmMedium": "none",
			"utmCampaign": "",
			"utmContent": "",
			"utmTerm": "",
			"accountName": "Factoring Total S.A.",
			"websiteName": "Leasing Total S.A.",
			"entryMethod": "CHATBOT",
			"tags": ["fired_new_lead", "posted_phone", "posted_email", "posted_international_phone", "ask_feedback_sent"],
			"entities": [{
				"slot_id": "availability",
				"values": ["Por las mañanas plan 10 am"]
			}, {
				"slot_id": "name",
				"values": ["Cely Bances"]
			}, {
				"slot_id": "email",
				"values": ["Cbancess@hotmail.com"]
			}],
			"extraParams": {
				"conversationId": "5f59307c54718c56cbcbd9e0",
				"contact_time": "por las mañanas plan 10 am",
				"firedTriggers[0]": "5ebdb74fccefca0028e5d638",
				"channel": "CHATBOT",
				"firedTriggers[1]": "5ebdb74fccefca0028e5d638",
				"body": "contact_time\u003dpor%20las%20ma%C3%B1anas%20plan%2010%20am\u0026final_question\u003dsi%20claro\u0026phoneVerified\u003d\u0026contactDni\u003d\u0026ldkCompanyId\u003d5e29a3c0e4b0b65c0e6bf51c\u0026ldkWebsiteId\u003d5ebda3d2b873210028328220\u0026ldkUtms\u003d\u0026conversationId\u003d5f59307c54718c56cbcbd9e0\u0026chatSessionId\u003d5f59307c54718c56cbcbd9e0\u0026firedTriggers%5B0%5D\u003d5ebdb74fccefca0028e5d638\u0026firedTriggers%5B1%5D\u003d5ebdb74fccefca0028e5d638\u0026channel\u003dCHATBOT\u0026chatUrl\u003dhttps%3A%2F%2Fwww.leasingtotal.com.pe%2F\u0026chatIp\u003d190.233.207.33\u0026chatLog\u003dcliente%3A%20HOLA%20buenas%20tardes%0Aasesor%3A%20Sera%20un%20placer%20asistirte%2C%20cual%20es%20su%20nombre%3F%0Acliente%3A%20cely%20bances%0Aasesor%3A%20%20yo%20me%20encargo%20de%20ponerte%20en%20contacto%20con%20un%20asesor%20para%20que%20responda%20tu%20consulta%0Aasesor%3A%20podr%C3%ADas%20dejarme%20tu%20tel%C3%A9fono%20completo%3F%0Acliente%3A%20986314575%20%20cely%20bances%0Aasesor%3A%20podr%C3%ADas%20dejarme%20tu%20email%3F%0Acliente%3A%20cbancess%40hotmail.com%0Aasesor%3A%20A%20que%20hora%20del%20d%C3%ADa%20prefieres%20que%20te%20llamemos%3F%0Acliente%3A%20por%20las%20ma%C3%B1anas%20plan%2010%20am%0Aasesor%3A%20quieres%20dejarme%20alguna%20consulta%20adicional%3F%0Acliente%3A%20si%20claro%0Aasesor%3A%20%20Muchas%20gracias%2C%20con%20esta%20informaci%C3%B3n%20un%20asesor%20se%20comunicar%C3%A1%20contigo%20a%20la%20brevedad.%0Acliente%3A%20tengo%20entendido%20que%20leasing%20dar%20creditos%20para%20compra%20de%20un%20inmueble%20o%20bienes%20%2C...%20la%20pregnta%20es%20tengo%20que%20ser%20persona%20natural%20o%20juridica%3F%0Aasesor%3A%20Somos%20una%20empresa%20de%20arrendamiento%20financiero%20con%20m%C3%A1s%20de%2020%20a%C3%B1os%20en%20el%20mercado.%20Nos%20especializamos%20en%20Maquinaria%20y%20Veh%C3%ADculos%21%0Acliente%3A%20tengo%20un%20negocio%20de%20transporte%20personal%20y%20necesito%20comprar%20un%20bus%2C%20leasing%20ouede%20gestionar%20la%20compra%20del%20vehiculo%3F%0Aasesor%3A%20Somos%20una%20empresa%20de%20arrendamiento%20financiero%20con%20m%C3%A1s%20de%2020%20a%C3%B1os%20en%20el%20mercado.%20Nos%20especializamos%20en%20Maquinaria%20y%20Veh%C3%ADculos%21%0Acliente%3A%20mi%20v%20ehiculo%20que%20necesito%20comprar%20es%20un%20bus%20de%20transporte%20personal%0Aasesor%3A%20Bien%2C%20me%20contacto%20con%20el%20asesor%20y%20le%20doy%20toda%20esta%20informaci%C3%B3n.%20Muchas%20gracias%20por%20comunicarte%21%0Acliente%3A%20gracias%20%20%20buenas%20tardes%0Aasesor%3A%20%0A\u0026chatName\u003d\u0026chatEmail\u003dcbancess%40hotmail.com\u0026chatPhone\u003d986%20314%20575\u0026chatInternationalPhone\u003d%2B51986314575\u0026chatIdNumber\u003d\u0026tags%5B0%5D\u003dfired_new_lead\u0026tags%5B1%5D\u003dask_feedback_sent\u0026tags%5B2%5D\u003dposted_email\u0026tags%5B3%5D\u003dposted_phone\u0026tags%5B4%5D\u003dposted_international_phone\u0026chatLeadFields%5Bcontact_time%5D\u003dpor%20las%20ma%C3%B1anas%20plan%2010%20am\u0026chatLeadFields%5Bfinal_question%5D\u003dsi%20claro",
				"tags[4]": "posted_international_phone",
				"ldkWebsiteId": "5ebda3d2b873210028328220",
				"ldkCompanyId": "5e29a3c0e4b0b65c0e6bf51c",
				"tags[1]": "ask_feedback_sent",
				"final_question": "si claro",
				"tags[0]": "fired_new_lead",
				"tags[3]": "posted_phone",
				"tags[2]": "posted_email"
			},
			"leadFields": {
				"final_question": "si claro",
				"contact_time": "por las mañanas plan 10 am"
			}
		}';
		return $json;
	}

}

global $curtime;
$curtime = date("YmdHis") . "_". uniqid() ;
$track = new Cliengo_Webhook();
error_log(print_r( "[$curtime]=========== ** INICIO ** =====================" , true));
$track->process(new Vtiger_Request($_REQUEST));
error_log(print_r( "[$curtime]=========== ** FIN ** =====================" , true));
http_response_code(200);