<?php

// Turn on debugging level
$Vtiger_Utils_Log = true;
#die;
// Include necessary classes
include_once('vtlib/Vtiger/Module.php');

// Define instances
$dealer = Vtiger_Module::getInstance('Dealer');

// Nouvelle instance pour le nouveau bloc
$block1 = createBlock('Segmentacion',$dealer);


//Tipo de Cuenta  * 
createField(['tipo_cuenta','vtiger_dealer','tipo_cuenta','Tipo de Cuenta','16',['Nuevo','Recurrente','Dealer']],$block1);
// Sector
createField(['sector','vtiger_dealer','sector','Secto','16',[
    'AGROINDUSTRIA',
    'AGROPECUARIO',
    'ALIMENTOS',
    'CONSTRUCCION',
    'EDUCACION',
    'ENERGIA',
    'HIDROCARBUROS',
    'HOGAR',
    'MANUFACTURA NO PRIMARIA',
    'MANUFACTURA PRIMARIA',
    'MINERIA',
    'PESCA',
    'SALUD',
    'SERVICIOS LOGISTICOS',
    'TECNOLOGIA',
    'TRANSPORTE',
    'TELECOMUNICACIONES',
    'COMERCIO',
    'OTROS',
    'ALQUILER DE MAQUINARIA',
    'ASESORÍA']
],$block1);

//Operaciones Leasing
createField(['operaciones_leasing','vtiger_dealer','operaciones_leasing','Operaciones Leasing','7'],$block1);
//Operaciones Factoring 
createField(['operaciones_factoring','vtiger_dealer','operaciones_factoring','Operaciones Factoring','7'],$block1);
//Aceptantes 1
createField(['aceptantes_1','vtiger_dealer','aceptantes_1','Aceptantes 1','1'],$block1);
//Sector de Frente de Trabajo 1
createField(['sector_ft1','vtiger_dealer','sector_ft1','Sector de Frente de Trabajo 1','1'],$block1);
//Aceptantes 2
createField(['aceptantes_2','vtiger_dealer','aceptantes_2','Aceptantes 2','1'],$block1);
//Sector de Frente de Trabajo 2
createField(['sector_ft2','vtiger_dealer','sector_ft2','Sector de Frente de Trabajo 2','1'],$block1);
//Aceptantes 3
createField(['aceptantes_3','vtiger_dealer','aceptantes_3','Aceptantes 3','1'],$block1);
//Sector de Frente de Trabajo 3
createField(['sector_ft3','vtiger_dealer','sector_ft3','Sector de Frente de Trabajo 3','1'],$block1);
//Aceptantes 4
createField(['aceptantes_4','vtiger_dealer','aceptantes_4','Aceptantes 4','1'],$block1);
//Sector de Frente de Trabajo 4
createField(['sector_ft4','vtiger_dealer','sector_ft4','Sector de Frente de Trabajo 4','1'],$block1);
//Aceptantes 5
createField(['aceptantes_5','vtiger_dealer','aceptantes_5','Aceptantes 5','1'],$block1);
//Sector de Frente de Trabajo 5
createField(['sector_ft5','vtiger_dealer','sector_ft5','Sector de Frente de Trabajo 5','1'],$block1);
//Linea Aprobada
createField(['linea_aprobada','vtiger_dealer','linea_aprobada','Linea Aprobada','71'],$block1);
//Linea Monto Utilizado
createField(['linea_monto','vtiger_dealer','linea_monto','Linea Monto Utilizado','71'],$block1);
//Fecha Última Transacción
createField(['ultima_transaccion','vtiger_dealer','ultima_transaccion','Fecha Última Transacción','5'],$block1);
#Detalles de la dirección
$block2 = createBlock('Detalles de la dirección',$dealer);
//Ubigeo (Fiscal) 
createField(['ubigeo_fiscal','vtiger_dealer','ubigeo_fiscal','Ubigeo (Fiscal)','10'],$block2);
//Dirección (Fiscal) 
createField(['direccion_fiscal','vtiger_dealer','direccion_fiscal','Dirección (Fiscal)','21'],$block2);
//Distrito (Fiscal) 
createField(['distrito_fiscal','vtiger_dealer','distrito_fiscal','Distrito (Fiscal)','1'],$block2);
//Provincia (Fiscal) 
createField(['provincia_fiscal','vtiger_dealer','provincia_fiscal','Provincia (Fiscal)','1'],$block2);
//Departamento (Fiscal) 
createField(['departamento_fiscal','vtiger_dealer','departamento_fiscal','Departamento (Fiscal)','1'],$block2);
#Detalles de la descripción
$block3 = createBlock('Detalles de la descripción',$dealer);
//Descripción
createField(['descripcion','vtiger_dealer','descripcion','Descripción','19'],$block3);
#Información específica 
$block4 = createBlock('Información específica',$dealer);
//No enviar correos
createField(['no_enviocorreo','vtiger_dealer','no_enviocorreo','No enviar correos','56'],$block4);
//Asesor Antiguo
createField(['asesor_antiguo','vtiger_dealer','asesor_antiguo','Asesor Antiguo','1'],$block4);




function createBlock($label,$instanceModule)
{
    global $adb;
    #$adb->setDebug(true);
    $blockValueMap = [
        'blocklabel' => $label,
        'display_status' => 1,
        'iscustom' => 0
    ];

    $block = new Vtiger_Block();
    $block = $block->getInstance($label,$instanceModule);
    if(empty($block))
    {   
        $block = new Vtiger_Block();
        $block->initialize($blockValueMap,$instanceModule);
        try {
            $block->save($instanceModule);
        } catch (Exception $ex) {
            throw new Exception($ex->getMessage());
        }
    }
    
    return $block;
}

function createField($attr,$block)
{
    global $adb;
    #$adb->setDebug(true);
    #Verifica que el campo no exista
    $q = $adb->pquery("SELECT fieldid FROM vtiger_field WHERE columnname = ? AND tablename = ?",[$attr[0],$attr[1]]);
    #$adb->setDebug(false);
    if($adb->num_rows($q) == 0)
    {
        $fieldInstance = new Vtiger_Field();
        $fieldInstance->name = $attr[0];			              //Usually matches column name
        $fieldInstance->table = $attr[1];
        $fieldInstance->column = $attr[2];		                     //Must be lower case
        $fieldInstance->label = $attr[3];		            //Upper case preceeded by LBL_
        $fieldInstance->columntype = 'TEXT';	    //
        $fieldInstance->uitype = $attr[4];			                   //Multi-Combo picklist
        $fieldInstance->displaytype = 1;
        $fieldInstance->typeofdata = 'V~O';	  //V=Varchar?, M=Mandatory, O=Optional

        if($fieldInstance->uitype == 16)
        {
            $fieldInstance->setPicklistValues($attr[5]);
        }

        $block->addField($fieldInstance);
    }
}
?>

