<?php 
require_once 'model.master.php';

class ImportModel extends ModelMaster{
	private $pdo;

	public function __CONSTRUCT(){
		$this->pdo = parent::getConexion();
	}

	
	//SE CREARAN LAS FUNCIONES PARA OBTENER LOS REGISTROS 
	
	//MIGUEL: 1° Se debe crear un tabla temporal con todos los campos que identifican al archivo, N COLUMNAS = N CAMPOS EN LA BASE DE DATOS 	
	public function ListarTablaTemporal(){
		try
		{
			//$sql = "SELECT *FROM usuarios WHERE estado = 1";
			$resultado = array();
			$comando = $this->pdo->prepare("select *from tmp_asignar_ejecutivo");
			$comando->execute(array());

			foreach($comando->fetchAll(PDO::FETCH_OBJ) as $fila){
				$filaDatos = array();
				$filaDatos[] = $fila->id;
				$filaDatos[] = $fila->rut;
				$filaDatos[] = $fila->user_name;

				$resultado[] = $filaDatos;
			}

			return $resultado;
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	//Obtenemos el ID del usuario con su user_name
	public function Obtener_IDUSUARIO($user_name){
		try
		{
			$sql = "SELECT id FROM vtiger_users WHERE user_name = ?";
			$comando = $this->pdo->prepare($sql);
			$comando->execute(array($user_name));

			$resultado = $comando->fetch(PDO::FETCH_OBJ);

			return $resultado;
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	public function Obtener_ACCOUNTID($rut){
		try
		{
			$sql = "SELECT accountid FROM vtiger_account WHERE siccode = ?";
			$comando = $this->pdo->prepare($sql);
			$comando->execute(array($rut));

			$resultado = $comando->fetchAll(PDO::FETCH_OBJ);

			return $resultado;
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	//Ahora hay que obtener los contactos asignados a esa cuenta 

	public function ObtenerCuentas_Account($accountid){
		try
		{
			$sql = "SELECT DISTINCT vtiger_crmentity.crmid
						FROM vtiger_contactdetails 
						INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_contactdetails.contactid 
						LEFT JOIN vtiger_account ON vtiger_account.accountid = vtiger_contactdetails.accountid 
						INNER JOIN vtiger_contactaddress ON vtiger_contactdetails.contactid = vtiger_contactaddress.contactaddressid 
						INNER JOIN vtiger_contactsubdetails ON vtiger_contactdetails.contactid = vtiger_contactsubdetails.contactsubscriptionid 
						INNER JOIN vtiger_customerdetails ON vtiger_contactdetails.contactid = vtiger_customerdetails.customerid 
						INNER JOIN vtiger_contactscf ON vtiger_contactdetails.contactid = vtiger_contactscf.contactid 
						WHERE vtiger_crmentity.deleted = 0 AND vtiger_contactdetails.accountid = ?";
			$resultado = array();
			$comando = $this->pdo->prepare($sql);
			$comando->execute(array($accountid));

			foreach($comando->fetchAll(PDO::FETCH_OBJ) as $fila){
				$filaDatos = array();
				$filaDatos[] = $fila->crmid;

				$resultado[] = $filaDatos;
			}

			return $resultado;
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}


	//Ahora hay que obtener los contactos asignados a esa cuenta 

	public function ObtenerOportunidades_Account($accountid){
		try
		{
			$sql = "SELECT DISTINCT vtiger_crmentity.crmid
						FROM vtiger_potential 
						INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_potential.potentialid 
						LEFT JOIN vtiger_account ON vtiger_account.accountid = vtiger_potential.related_to 
						INNER JOIN vtiger_potentialscf ON vtiger_potential.potentialid = vtiger_potentialscf.potentialid 
						LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id 
						WHERE vtiger_crmentity.deleted = 0 AND vtiger_potential.related_to = ?";
			$resultado = array();
			$comando = $this->pdo->prepare($sql);
			$comando->execute(array($accountid));

			foreach($comando->fetchAll(PDO::FETCH_OBJ) as $fila){
				$filaDatos = array();
				$filaDatos[] = $fila->crmid;

				$resultado[] = $filaDatos;
			}

			return $resultado;
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	//Obtenemos el ultimo modtracker 
	public function UltimoMODTRACKER_BASIC(){
		try
		{
			$sql = "select id from vtiger_modtracker_basic order by id desc limit 1";

			$comando = $this->pdo->prepare($sql);
			$comando->execute();

			$resultado = $comando->fetch(PDO::FETCH_OBJ);

			return $resultado;
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	//Función para registrar en la tabla VTIGER_NOTESCF
	public function RegistrarMODTRACKER_BASIC($id,$crmid,$module,$whodid,$changedon,$status){
		try
		{
			$sql = "insert into vtiger_modtracker_basic (id,crmid,module,whodid,changedon,status) values(?,?,?,?,?,?)";
			$comando = $this->pdo->prepare($sql);
			$comando->execute(array($id,$crmid,$module,$whodid,$changedon,$status));
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	//Función para actualizar MODTRACKER_BASIC_SEQ
	public function UpdateMODTRACKER_BASIC_SEQ($val){
		try
		{
			$sql = "update vtiger_modtracker_basic_seq set id = ?";
			$comando = $this->pdo->prepare($sql);
			$comando->execute(array($val));
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	//Ahora registramos en la tabla VTIGER_MODTRACKER_DETAIL
	public function RegistrarMODTRACKER_DETAIL($id,$fieldname,$prevalue,$postvalue){
		try
		{
			$sql = "insert into vtiger_modtracker_detail (id,fieldname,prevalue,postvalue) values(?,?,?,?)";
			$comando = $this->pdo->prepare($sql);
			$comando->execute(array($id,$fieldname,$prevalue,$postvalue));
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	//Obtenemos los datos anteriores del crmentity
	public function ObtenerDatos_CRMActuales($crmid){
		try
		{
			$sql = "SELECT smownerid,description FROM vtiger_crmentity WHERE crmid = ?";

			$comando = $this->pdo->prepare($sql);
			$comando->execute(array($crmid));

			$resultado = $comando->fetch(PDO::FETCH_OBJ);

			return $resultado;
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	//Función para actualizar el ultimo registro de CRMENTITY_SEQ
	public function Update_CRMENTITY($user_asignated,$description,$modifiedtime,$crmid){
		try
		{
			$sql = "UPDATE vtiger_crmentity SET modifiedby = 1, smownerid = ?, description = ? , modifiedtime = ? WHERE crmid = ?";
			$comando = $this->pdo->prepare($sql);
			$comando->execute(array($user_asignated,$description,$modifiedtime,$crmid));
		}
		catch(Exception $e){
			die($e->getMessage());
		}
	}

	
}

?>