<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Configurar Exportar</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" integrity="sha384-B0vP5xmATw1+K9KRQjQERJvTumQW0nPEzvF6L/Z6nronJ3oUOFUFpCjEUQouq2+l" crossorigin="anonymous">
</head>
<body>
  <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <a class="navbar-brand" href="index.php">Creantis</a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarSupportedContent">
      <ul class="navbar-nav mr-auto">
        <li class="nav-item active">
          <a class="nav-link" href="index.php">Importación de Datos <span class="sr-only">(current)</span></a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="reporte_importacion.php">Reporte de Importación</a>
        </li>
        
       
      </ul>
      
    </div>
  </nav>

  <div class="container">
    <div class="row" style="margin-top: 1em">
      <div class="col-md-12" style="text-align: center">
        <div class="alert alert-secondary" role="alert">
          Para asociar los documentos primero cargue la tabla temporal <strong>(tmp_document)</strong> luego presionamos en el botón de asociar documentos, una vez asociado el documento se eliminaran los registros de la tabla temporal y pasaran a la <strong>(tmp_document_report)</strong> donde podremos visualizar el reporte de los documento y carpetas asociados hasta el momento. 
        </div>
      </div>

    </div>
    <!-- <div class="row">
      <div class="col-md-6" >
        <label for="carpetas_sql">Listas de Carpetas:</label>
        <select name="carpetas_sql" id="carpetas_sql">
          <option value=""></option>
        </select>
      </div>
      <div class="col-md-6" >
        
      </div>
    </div> -->

    <div class="row">
      <div class="col-md-6" ></div>
      <div class="col-md-4" >
        <button type="button" class="btn btn-danger btn-block" id="btnasociar">Comenzar asociar documentos</button>
      </div>
      <div class="col-md-2" >
        <button class="button btn btn-success btn-block" type="button" id="btnrefrescar">Refrescar</button>
      </div>
    </div>

    <div class="row" style="margin-top: 2em">
      <div class="col-md-12" id="registros">
        
      </div>
    </div>
  </div>
  
  
  <script src="https://code.jquery.com/jquery-3.5.1.js" integrity="sha256-QWo7LDvxbWT2tbbQ97B53yJnYU3WhH/C8ycbRAkjPDc=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js" integrity="sha384-Piv4xVNRyMGpqkS2by6br4gNJ7DXjqk09RmUpJ8jgGtD7zP9yug3goQfGII0yAns" crossorigin="anonymous"></script>

<script>
  $(document).ready(function(){

    //Vamos a agrupar las listas de carpetas a las que vamos a mover los archivos 

    function ListarRegistros(){
      $.ajax({
        url:'export_data_file.php',
        type:'GET',
        data:'operacion=listartabla',
        beforeSend:function(e){
          //alert(e);
            $("#registros").html('<div style="text-align: center;"><img src="loader.gif" alt="" ></div>');
        },
        success:function(e){
          //alert(e);
          $("#registros").html(e);
        }
      });
    }

    //Ahora listamos los registros
    ListarRegistros();

    //Preguntamos antes de empezar el procesos para asociar un documento 
    $("#btnasociar").click(function(){
      
      if(confirm("¿Esta seguro de empezar ?")){
        $.ajax({
          url:'export_data_file.php',
          type:'GET',
          data:'operacion=asociardocument',
          beforeSend:function(e){
            //alert(e);
              $("#registros").html('<div style="text-align: center;"><img src="loader.gif" alt="" ></div>');
          },
          success:function(e){
            //alert(e);
            $("#registros").html(e);
          }
        });
      }
      
    });

    //En caso no se hallan cargados los registros temporales los refrescamos 
    $("#btnrefrescar").click(function(){
      ListarRegistros();
    });

  });
</script>
</body>
</html>