<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Configurar Exportar</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" integrity="sha384-B0vP5xmATw1+K9KRQjQERJvTumQW0nPEzvF6L/Z6nronJ3oUOFUFpCjEUQouq2+l" crossorigin="anonymous">
</head>
<body>
  <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <a class="navbar-brand" href="index.php">Creantis</a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarSupportedContent">
      <ul class="navbar-nav mr-auto">
        <li class="nav-item">
          <a class="nav-link" href="index.php">Importación de Datos <span class="sr-only">(current)</span></a>
        </li>
        <li class="nav-item active">
          <a class="nav-link" href="reporte_importacion.php">Reporte de Importación</a>
        </li>
        
       
      </ul>
      
    </div>
  </nav>

  <div class="container">
    <div class="row" style="margin-top: 1em">
      <div class="col-md-12 col-sm-12 col-xl-12" style="text-align: center">
        <div class="alert alert-secondary" role="alert">
          <strong>Nota:</strong> Para ver los documentos que ya se encuentran asociados, seleccionamos la carpeta y presionamos clic en generar
          <br>
          <span>*Si el documento no se asocio es porque no se encontro en Oportunidades, Cuentas,Contactos o Proyectos. </span>
        </div>
      </div>

    </div>

    <div class="row">
      <div class="col-md-6" >
        <label for="carpetas_sql">Listas de Carpetas:</label>
        <select name="carpetas_sql" id="carpetas_sql" class="form-control">
          <option value="">Seleccione</option>
        </select>
      </div>
      <div class="col-md-2" ></div>
      <div class="col-md-2" style="margin-top: 2em">
        <button class="btn btn-primary btn-block" id="btngenerar" type="button">Generar reporte</button>
      </div>
      <div class="col-md-2" style="margin-top: 2em">
        <button class="btn btn-success btn-block" type="button" onclick="tableToExcel('reporte')">Exportar XLS</button>
      </div>
    </div>

    <!-- <div class="row" style="margin-top: 2em">
      <div class="col-md-2" ></div>
      <div class="col-md-8" >
        <button type="button" class="btn btn-success btn-block" id="btnasociar"> Comenzar a asociar Documentos</button>
      </div>
      <div class="col-md-2" ></div>
    </div> -->

    <div class="row" style="margin-top: 2em">
      <div class="col-md-12" id="reporte">
        
      </div>
    </div>
  </div>
  
  
  <script src="https://code.jquery.com/jquery-3.5.1.js" integrity="sha256-QWo7LDvxbWT2tbbQ97B53yJnYU3WhH/C8ycbRAkjPDc=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js" integrity="sha384-Piv4xVNRyMGpqkS2by6br4gNJ7DXjqk09RmUpJ8jgGtD7zP9yug3goQfGII0yAns" crossorigin="anonymous"></script>

<script>
  var tableToExcel = (function() {
      var uri = 'data:application/vnd.ms-excel;base64,'
        , template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><meta http-equiv="content-type" content="application/vnd.ms-excel; charset=UTF-8"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>'
        , base64 = function(s) { return window.btoa(unescape(encodeURIComponent(s))) }
        , format = function(s, c) { return s.replace(/{(\w+)}/g, function(m, p) { return c[p]; }) }
      return function(table, name) {
        if (!table.nodeType) table = document.getElementById(table)
        var ctx = {worksheet: name || 'Worksheet', table: table.innerHTML}
        window.location.href = uri + base64(format(template,
        
        ctx))
      }
    })()

  $(document).ready(function(){

    //Vamos a agrupar las listas de carpetas a las que vamos a mover los archivos 

    function ObtenerCarpetas(){
      $.ajax({
        url:'report.controller.php',
        type:'GET',
        data:'operacion=carpetas',
        success:function(e){
          //alert(e);
          $("#carpetas_sql").html(e);
        }
      });
    }

    //Ahora listamos los registros
    ObtenerCarpetas();

    //Generamos el reporte 
    $("#btngenerar").click(function(){
      let carpeta = $("#carpetas_sql").val();
      //alert(carpeta);

        $.ajax({
          url:'report.controller.php',
          type:'GET',
          data:'operacion=report&carpeta='+carpeta,
          beforeSend:function(e){
            //alert(e);
              $("#reporte").html('<div style="text-align: center;"><img src="loader.gif" alt="" ></div>');
          },
          success:function(e){
            //alert(e);
            $("#reporte").html(e);
          }
        });
  
      
    });

  });
</script>
</body>
</html>