<?php

/*+*******************************************************************************
 *   The contents of this file are subject to the vtiger CRM Public License Version 1.0
 *   ("License"); You may not use this file except in compliance with the License
 *   The Original Code is:  vtiger CRM Open Source
 *   The Initial Developer of the Original Code is vtiger.
 *   Portions created by vtiger are Copyright (C) vtiger.
 *   All Rights Reserved.
 * 
 *********************************************************************************/

/**
 * @author Musavir Ahmed Khan<musavir at vtiger.com>
 */

/**
 *
 * @param WebserviceId $id
 * @param String $oldPassword
 * @param String $newPassword
 * @param String $confirmPassword
 * @param Users $user 
 * 
 */
function vtws_changePassword($id, $oldPassword, $newPassword, $confirmPassword, $user) {
	vtws_preserveGlobal('current_user',$user);
	$idComponents = vtws_getIdComponents($id);
	if($idComponents[1] == $user->id || is_admin($user)) {
		$newUser = new Users();
		$newUser->retrieve_entity_info($idComponents[1], 'Users');
		if(!is_admin($user)) {
			if(empty($oldPassword)) {
				throw new WebServiceException(WebServiceErrorCode::$INVALIDOLDPASSWORD, 
					vtws_getWebserviceTranslatedString('LBL_'.
							WebServiceErrorCode::$INVALIDOLDPASSWORD));
			}
			if(!$user->verifyPassword($oldPassword)) {
				throw new WebServiceException(WebServiceErrorCode::$INVALIDOLDPASSWORD, 
					vtws_getWebserviceTranslatedString('LBL_'.
							WebServiceErrorCode::$INVALIDOLDPASSWORD));
			}
		}
		if(strcmp($newPassword, $confirmPassword) === 0) {
			$db = PearDatabase::getInstance();
			$db->dieOnError = true;
			// $db->startTransaction(); //--Henry# se comenta el inicio de transaccion para poder guardar contraseña
			$success = $newUser->change_password($oldPassword, $newPassword, false);
			$error = $db->hasFailedTransaction();
			$db->completeTransaction();
			if($error) {
				throw new WebServiceException(WebServiceErrorCode::$DATABASEQUERYERROR, 
					vtws_getWebserviceTranslatedString('LBL_'.
							WebServiceErrorCode::$DATABASEQUERYERROR));
			}
			if(!$success) {
				throw new WebServiceException(WebServiceErrorCode::$CHANGEPASSWORDFAILURE, 
					vtws_getWebserviceTranslatedString('LBL_'.
							WebServiceErrorCode::$CHANGEPASSWORDFAILURE));
			}
		} else {
			throw new WebServiceException(WebServiceErrorCode::$CHANGEPASSWORDFAILURE, 
					vtws_getWebserviceTranslatedString('LBL_'.
							WebServiceErrorCode::$CHANGEPASSWORDFAILURE));
		}
		VTWS_PreserveGlobal::flush();
		#Elias, si el usuario cambia su clave, actualiza el indicar de cambio de clave 0 para que ya no 
		#le salga el modal para cambiar de clave cada vez que inicie sesión
		global $max_password_lifetime;

		$ultimo_cambio_pwd = date('Y-m-d');

		$siguiente_cambio_pwd = date('Y-m-d',strtotime($ultimo_cambio_pwd.' + '.$max_password_lifetime.'days'));

		$db->pquery("UPDATE vtiger_users SET change_pwd = 0, ultimo_cambio_pwd = ?, siguiente_cambio_pwd = ? WHERE id = ?",[$ultimo_cambio_pwd,$siguiente_cambio_pwd,$idComponents[1]]);
		$userModel = new Users();
		$userQuery = $db->pquery("SELECT crypt_type FROM vtiger_users WHERE id = ?",[$idComponents[1]]);
		#Agrega la nueva contraseña al historial de contraseña
		$crypt_type = $db->query_result($userQuery,0,'crypt_type');
		$encrypted_pwd = $userModel->encrypt_password($newPassword, $crypt_type);
		#$db->setDebug(true);
		$db->pquery("INSERT INTO vtiger_password_history (id_user, password_enc, password) VALUES(?,?,?)",[$idComponents[1],$encrypted_pwd,$newPassword]);
		
		#setcookie("change_pwd", 0);
		return array('message' => 'Changed password successfully');
	}
}
?>