{*+**********************************************************************************
* The contents of this file are subject to the vtiger CRM Public License Version 1.1
* ("License"); You may not use this file except in compliance with the License
* The Original Code is: vtiger CRM Open Source
* The Initial Developer of the Original Code is vtiger.
* Portions created by vtiger are Copyright (C) vtiger.
* All Rights Reserved.
************************************************************************************}
{* modules/Vtiger/views/MassActionAjax.php *}
    
{* START YOUR IMPLEMENTATION FROM BELOW. Use {debug} for information *}
{strip}
    <div class="modal-dialog">
        <div class="modal-content">
            <form class="form-horizontal" id="changeOwner" name="changeOwner" method="post" action="index.php">
                <input type="hidden" name="module" value="{$MODULE}" />
                <input type="hidden" name="action" value="TransferOwnership" />

                
            
                <div class="modal-header">
                    <div class="clearfix">
                        <div class="pull-right " >
                            <button type="button" class="close" aria-label="Close" data-dismiss="modal">
                                <span aria-hidden="true" class='fa fa-close'></span>
                            </button>
                        </div>
                        <h4 class="pull-left" id="titulo_tranferencia">
                            Se transferiran X/Y cuentas a cada ejecutivo
                        </h4>
                    </div>
                </div>
                
                <div class="modal-body">
                    <div class="form-group">
                            <div class="col-lg-1"></div>
                            <div class="col-lg-10" style="text-align: center">
                                <h5> <strong id="cantidad_cuentas_selected">0</strong> cuentas seleccionadas | <strong id="cantidad_ejecutivos_selected">0</strong> ejecutivos seleccionados</h5>
                            </div>
                            <div class="col-lg-1"></div>
                    </div>
                    <div class="form-group">
                            <label class="col-lg-4 control-label">{vtranslate('LBL_SELECT_RELATED_MODULES',$MODULE)}</label>
                            <div class="col-lg-6">
                                <select multiple class="form-control select2" id="related_modules" data-placeholder="{vtranslate('LBL_SELECT_RELATED_MODULES',$MODULE)}" name="related_modules[]" data-rule-required="true">
                                    {foreach item=RELATED_MODULE from=$RELATED_MODULES}
                                        {if !in_array($RELATED_MODULE->get('relatedModuleName'), $SKIP_MODULES)}
                                            <option value="{$RELATED_MODULE->get('relation_id')}">{vtranslate($RELATED_MODULE->get('label'), $RELATED_MODULE->get('relatedModuleName'))}</option>
                                        {/if}
                                    {/foreach}
                                </select>
                            </div>
                    </div>
                    <!-- <div class="form-group">
                            <label class="col-lg-4 control-label">{vtranslate('LBL_ASSIGNED_TO', $MODULE)}</label>
                            <div class="col-lg-6">
                                {assign var=ALL_ACTIVEUSER_LIST value=$USER_MODEL->getAccessibleUsers()}
                                {assign var=ALL_ACTIVEGROUP_LIST value=$USER_MODEL->getAccessibleGroups()}
                                {assign var=CURRENT_USER_ID value=$USER_MODEL->get('id')}
                                {assign var=ACCESSIBLE_USER_LIST value=$USER_MODEL->getAccessibleUsersForModule($MODULE)}
                                {assign var=ACCESSIBLE_GROUP_LIST value=$USER_MODEL->getAccessibleGroupForModule($MODULE)}
                                
                                <select class="form-control select2" name="transferOwnerId" id="transferOwnerId">
                                    <optgroup label="{vtranslate('LBL_USERS')}">
                                        {foreach key=OWNER_ID item=OWNER_NAME from=$ALL_ACTIVEUSER_LIST}
                                            <option value="{$OWNER_ID}" data-picklistvalue= '{$OWNER_NAME}' {if $FIELD_VALUE eq $OWNER_ID} selected {/if}
                                                    {if array_key_exists($OWNER_ID, $ACCESSIBLE_USER_LIST)} data-recordaccess=true {else} data-recordaccess=false {/if}
                                                    data-userId="{$CURRENT_USER_ID}">
                                                {$OWNER_NAME}
                                            </option>
                                        {/foreach}
                                    </optgroup>
                                    <optgroup label="{vtranslate('LBL_GROUPS')}">
                                        {foreach key=OWNER_ID item=OWNER_NAME from=$ALL_ACTIVEGROUP_LIST}
                                            <option value="{$OWNER_ID}" data-picklistvalue= '{$OWNER_NAME}'
                                                    {if array_key_exists($OWNER_ID, $ACCESSIBLE_GROUP_LIST)} data-recordaccess=true {else} data-recordaccess=false {/if} >
                                                {$OWNER_NAME}
                                            </option>
                                        {/foreach}
                                    </optgroup>
                                </select>
                            </div>
                    </div> -->
                    <div class="form-group">
                            <label class="col-lg-4 control-label">Seleccionar ejecutivos</label>
                            <div class="col-lg-6" class="checkbox">
                                <!-- <span>{$USUARIOS_EJECUTIVOS|@var_dump}</span> -->
                                <div class="col-lg-6 col-md-6 col-xl-6">
                                    <table class="table table-bordered table-striped">
                                      <thead style="background-color: #596875;color:white">
                                        <tr>
                                          <th scope="col" style="text-align: center" >Leasing</th>
                                        </tr>
                                      </thead>
                                      <tbody>
                                     {foreach key=OWNER_ID item=OWNER_NAME from=$ALL_ACTIVEUSER_LIST}
                                            <tr>
                                                <!-- Vamos a buscar si es Leasing o Factoring  -->
                                                {if $USUARIOS_EJECUTIVOS[$OWNER_ID] eq 'Leasing'}
                                                    <td>
                                                        <label><input type="checkbox" value="{$OWNER_ID}" name="transferOwnerId[]" style="margin-left: 3px" class="chk_ejecutivo"> {$OWNER_NAME}</label> 
                                                     </td>
                                                {/if}  
                                            </tr>
                                        
                                    {/foreach}
                                          </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-6 col-md-6 col-xl-6">
                                    <table class="table table-bordered table-striped">
                                      <thead style="background-color: #596875;color:white">
                                        <tr>
                                          <th scope="col" style="text-align: center">Factoring</th>
                                        </tr>
                                      </thead>
                                      <tbody>
                                         {foreach key=OWNER_ID item=OWNER_NAME from=$ALL_ACTIVEUSER_LIST}
                                                <tr>
                                                    <!-- Vamos a buscar si es Leasing o Factoring  -->
                                                    {if $USUARIOS_EJECUTIVOS[$OWNER_ID] eq 'Factoring'}
                                                        <td>
                                                            <label><input type="checkbox" value="{$OWNER_ID}" name="transferOwnerId[]" style="margin-left: 3px" class="chk_ejecutivo"> {$OWNER_NAME}</label> 
                                                         </td>
                                                    {/if}  
                                                </tr>
                                            
                                        {/foreach}
                                              </tbody>
                                        </table>
                                </div>
                                 

                                
                                
                            </div>
                    </div>
                </div>
                <div class="modal-footer ">
                    <center>
                        {if $BUTTON_NAME neq null}
                            {assign var=BUTTON_LABEL value=$BUTTON_NAME}
                        {else}
                            {assign var=BUTTON_LABEL value={vtranslate('LBL_SAVE', $MODULE)}}
                        {/if}
                        <button class="btn btn-success" type="button" id="btnPreguntar"><strong>Transferir</strong></button>

                        <button {if $BUTTON_ID neq null} id="{$BUTTON_ID}" {/if} class="btn btn-success" type="submit" name="saveButton" style="display: none" id="btnComenzarTransferencia"><strong>Transferir</strong></button>
                        <a href="#" class="cancelLink" type="reset" data-dismiss="modal">{vtranslate('LBL_CANCEL', $MODULE)}</a>
                    </center>
                </div>
            </form>
        </div>
    </div>

{/strip}
{literal}
<script type="text/javascript">
$(document).ready(function(){
    //Al cargar seteamos por default los modulos asociados
    //Setemos los valores de Oportunidades = 2 y Contactos = 1
    $("select[name='related_modules[]']").val(['1','2']).trigger("change");
    //$("select[name='related_modules[]']").val(2).trigger("change");

   //Vamos a obtener los checkes que seleccionemos 
   $(".chk_ejecutivo").click(function(){
       let checked_selected = $(".chk_ejecutivo:checked").length;
       $("#cantidad_ejecutivos_selected").text(checked_selected);

       let cantidad_selected = $("#cantidad_cuentas_selected").text();
       let titulo_tranferencia = "Se transferiran "+cantidad_selected+"/"+checked_selected+" cuentas a cada ejecutivo";

       $("#titulo_tranferencia").text(titulo_tranferencia);
       //alert("hola");

       

   });

   $("#btnPreguntar").click(function(){
    let mensaje = $("#titulo_tranferencia").text();
    if(confirm(mensaje+". ¿Está seguro de continuar?")){
        $("#btnComenzarTransferencia").trigger("click");
    }
   });
});
</script>
{/literal}