/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Vtiger_Edit_Js("Accounts_Edit_Js", {

}, {

    //This will store the editview form
    editViewForm: false,

    //Address field mapping within module
    addressFieldsMappingInModule: {
        'bill_street': 'ship_street',
        'bill_pobox': 'ship_pobox',
        'bill_city': 'ship_city',
        'bill_state': 'ship_state',
        'bill_code': 'ship_code',
        'bill_country': 'ship_country'
    },

    // mapping address fields of MemberOf field in the module              
    memberOfAddressFieldsMapping: {
        'bill_street': 'bill_street',
        'bill_pobox': 'bill_pobox',
        'bill_city': 'bill_city',
        'bill_state': 'bill_state',
        'bill_code': 'bill_code',
        'bill_country': 'bill_country',
        'ship_street': 'ship_street',
        'ship_pobox': 'ship_pobox',
        'ship_city': 'ship_city',
        'ship_state': 'ship_state',
        'ship_code': 'ship_code',
        'ship_country': 'ship_country'
    },
    /**
     * Function to swap array
     * @param Array that need to be swapped
     */
    swapObject: function(objectToSwap) {
        var swappedArray = {};
        var newKey, newValue;
        for (var key in objectToSwap) {
            newKey = objectToSwap[key];
            newValue = key;
            swappedArray[newKey] = newValue;
        }
        return swappedArray;
    },

    /**
     * Function to copy address between fields
     * @param strings which accepts value as either odd or even
     */
    copyAddress: function(swapMode, container) {
        var thisInstance = this;
        var addressMapping = this.addressFieldsMappingInModule;
        if (swapMode == "false") {
            for (var key in addressMapping) {
                var fromElement = container.find('[name="' + key + '"]');
                var toElement = container.find('[name="' + addressMapping[key] + '"]');
                toElement.val(fromElement.val());
            }
        } else if (swapMode) {
            var swappedArray = thisInstance.swapObject(addressMapping);
            for (var key in swappedArray) {
                var fromElement = container.find('[name="' + key + '"]');
                var toElement = container.find('[name="' + swappedArray[key] + '"]');
                toElement.val(fromElement.val());
            }
        }
    },

    /**
     * Function to register event for copying address between two fileds
     */
    registerEventForCopyingAddress: function(container) {
        var thisInstance = this;
        var swapMode;
        jQuery('[name="copyAddress"]').on('click', function(e) {
            var element = jQuery(e.currentTarget);
            var target = element.data('target');
            if (target == "billing") {
                swapMode = "false";
            } else if (target == "shipping") {
                swapMode = "true";
            }
            thisInstance.copyAddress(swapMode, container);
        })
    },

    getRecordId: function(container) {

        return jQuery('input[name="record"]', container).val();

    },
    setUbigeo: function(crmid) {
        var url = "index.php?module=Accounts&action=GetData&record=" + crmid + "&source_module=Ubigeo";
        app.helper.showProgress();
        app.request.get({ "url": url }).then(
            function(err, data) {
                app.helper.hideProgress();
                if (err === null) {
                    console.log("data", data)
                    if (data.success) {
                        var obj = data.data;
                        $("#Accounts_editView_fieldName_bill_city").val(obj.ubigeo_tks_distrito);
                        $("#Accounts_editView_fieldName_bill_state").val(obj.ubigeo_tks_provincia);
                        $("#Accounts_editView_fieldName_bill_pobox").val(obj.ubigeo_tks_departamento);
                    } else {
                        app.helper.showErrorNotification({ "message": data.message });
                    }
                } else {
                    app.helper.showErrorNotification({ "message": err });
                }
            });
    },

    initAccount: function(container) {
        $("#Accounts_editView_fieldName_bill_city").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly ubigeo
        $("#Accounts_editView_fieldName_bill_state").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly ubigeo
        $("#Accounts_editView_fieldName_bill_pobox").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly ubigeo

        $("#Accounts_editView_fieldName_cf_908").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly
        $("#Accounts_editView_fieldName_cf_910").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly
        $("#Accounts_editView_fieldName_accountname").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly
        //console.log("hola");
        var name1 = $('select[name="cf_852"]');
        var leadsource = $('select[name="leadsource"]');
        var nombre = $('#Accounts_editView_fieldName_cf_908');
        var apellido = $('#Accounts_editView_fieldName_cf_910');
        var accountname = $('#Accounts_editView_fieldName_accountname');

        var view = '';
        var tab_label = '';
        var thisInstance = this;
        var queryString = window.location.search;
        var urlParams = new URLSearchParams(queryString);
        if (urlParams.has('view')) view = urlParams.get('view');
        if (urlParams.has('tab_label')) tab_label = urlParams.get('tab_label');

        name1.on('change', function() {
            if ($('select[name="cf_852"]').val() == 'Natural') {
                console.log("natural");
                $('#Accounts_editView_fieldName_cf_908').removeAttr("readonly");
                $("#Accounts_editView_fieldName_cf_908").css("background-color", "");
                $('#Accounts_editView_fieldName_cf_910').removeAttr("readonly");
                $("#Accounts_editView_fieldName_cf_910").css("background-color", "");
                $('#Accounts_editView_fieldName_cf_908').attr("required", true);
                $('#Accounts_editView_fieldName_cf_910').attr("required", true);
                $("#Accounts_editView_fieldName_accountname").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly
                apellido.blur(function() {
                    accountname.val(nombre.val() + " " + apellido.val());
                });
                nombre.blur(function() {
                    accountname.val(nombre.val() + " " + apellido.val());
                });
            } else if ($('select[name="cf_852"]').val() == 'Juridica') {
                $('#Accounts_editView_fieldName_cf_908').removeAttr("required");
                $('#Accounts_editView_fieldName_cf_910').removeAttr("required");
                $("#Accounts_editView_fieldName_cf_908").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly
                $("#Accounts_editView_fieldName_cf_910").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly
                $('#Accounts_editView_fieldName_accountname').removeAttr("readonly");
                $("#Accounts_editView_fieldName_accountname").css("background-color", "");
                nombre.val("");
                apellido.val("");
            }
        });

        name1.trigger("change");

        $("#Accounts_editView_fieldName_cf_882").attr("readonly", true).css("background-color", "rgb(235, 235, 228)");
        $("#Accounts_editView_fieldName_cf_854").attr("readonly", true).css("background-color", "rgb(235, 235, 228)");

        // el bloqueo no debe afectar al administrador del sistema
        var is_admin = _USERMETA.is_admin;

        if (is_admin == "false") {
            $("select[name='leadsource'] option[value='Chatbot']").attr("disabled", true);
            $("select[name='leadsource'] option[value='Chatbot']").removeClass("picklistColor_leadsource_Chatbot");
            $("select[name='leadsource'] option[value='Chatbot']").css("background-color", "rgb(97, 98, 100) !important");
            $("select[name='leadsource'] option[value='Landing Page']").attr("disabled", true);
            $("select[name='leadsource'] option[value='Landing Page']").removeClass("picklistColor_leadsource_Landing_Page");
            $("select[name='leadsource'] option[value='Landing Page']").css("background-color", "rgb(97, 98, 100) !important");
        }

        // solo Cuando el origen está lleno no lo deja editar
        if (is_admin == "false" && $('select[name="leadsource"]').val() != '' && (thisInstance.getRecordId(container) != '' && thisInstance.getRecordId(container) != undefined)) {
            $('select[name="leadsource"]').attr("readonly", true).css("background-color", "rgb(235, 235, 228)");
        }

        //Agrega el boton para buscar RUC en sentinel
        var nombreElm = "siccode";
        var elmRUC = $('input[name=' + nombreElm + ']');
        var spanPadre = elmRUC.parent();
        var ruc = $('input[name=siccode]').val();
        spanPadre.html('<div class="referencefield-wrapper ">' +
            '<div class="input-group">' +
            '<input name="representantes" type="hidden" id="representantes">' +
            '<input id="Accounts_editView_fieldName_' + nombreElm + '" type="text" class="marginLeftZero inputElement "' +
            'name="' + nombreElm + '" value="">' +
            '<span class="input-group-addon cursorPointer" title="Buscar en Sentinel"><i id="buscarRUC_Sentinel" class="fa fa-search"></i></span>' +
            '</div>' +
            '</div>');
        $('input[name=siccode]').val(ruc);
        $(document).on('click', '#buscarRUC_Sentinel', function() {
            let ruc = $('input[name=siccode]').val();
            if (ruc) {
                var params = {
                    'module': 'Accounts',
                    'action': 'getSentinelData',
                    'ruc': ruc,
                    'record': $('input[name="record"]').val()
                }
                app.helper.showProgress();
                app.request.post({ data: params }).then(function(err, result) {
                    if (!err) {
                        app.helper.hideProgress();
                        if (result.duplicado) {
                            var options = {
                                message: "La cuenta ya existe, si desea actualizar sus datos ingrese a la opción de modificar.",
                                title: 'Esta cuenta ya existe.'
                            }
                            var settings = {
                                'delay': 0
                            };
                            app.helper.showErrorNotification(options, settings);
                        } else {
                            if (result.data) {
                                let string_ = JSON.parse(result.data);
                                let data = string_.result;
                                console.log(string_);
                                $('[name=representantes]').val(JSON.stringify(data.representante_legal));
                                $('[name=accountname]').val(data.razon_social);
                                $('[name=bill_street]').val(data.domicilio_fiscal);
                                $('[name=bill_city]').val(data.distrito);
                                $('[name=bill_state]').val(data.provincia);
                                $('[name=bill_pobox]').val(data.departamento);
                                switch (data.tipo_documento) {
                                    case 'R':
                                        $('[name=cf_852]').val('Juridica');
                                        break;

                                    default:
                                        $('[name=cf_852]').val('Natural');
                                        break;
                                }
                                $('[name=cf_852]').select2();

                            } else {
                                var options = {
                                    message: "No se encontraron datos.",
                                    title: 'No hay datos de este RUC.'
                                }
                                var settings = {
                                    'delay': 0
                                };
                                app.helper.showErrorNotification(options, settings);
                            }
                        }
                    }
                });
            }
        });
    },
    /**
     * Function which will copy the address details - without Confirmation
     */

    copyAddressDetails: function(data, container) {
        var thisInstance = this;
        thisInstance.getRecordDetails(data).then(
            function(data) {
                var response = data['result'];
                thisInstance.mapAddressDetails(thisInstance.memberOfAddressFieldsMapping, response['data'], container);
            },
            function(error, err) {

            });
    },

    /**
     * Function which will map the address details of the selected record
     */
    mapAddressDetails: function(addressDetails, result, container) {
        for (var key in addressDetails) {
            // While Quick Creat we don't have address fields, we should  add
            if (container.find('[name="' + key + '"]').length == 0) {
                container.append("<input type='hidden' name='" + key + "'>");
            }
            container.find('[name="' + key + '"]').val(result[addressDetails[key]]);
            container.find('[name="' + key + '"]').trigger('change');
            container.find('[name="' + addressDetails[key] + '"]').val(result[addressDetails[key]]);
            container.find('[name="' + addressDetails[key] + '"]').trigger('change');
        }
    },

    /**
     * Function which will register basic events which will be used in quick create as well
     *
     */
    registerBasicEvents: function(container) {
        this._super(container);
        this.initAccount(container);
        this.registerEventForCopyingAddress(container);
    }
});