/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
Vtiger_Edit_Js("Assets_Edit_Js",{},{
	
	

	initAssets : function(container){
		var thiInstance = this;

		//Bloqueamos los campos que se obtendran automaticamente
		$("#Assets_editView_fieldName_cf_1072").attr("readonly",true).css("background-color","rgb(235, 235, 228)"); // Modelo 
		$("[name='cf_1064']").attr("readonly",true).css("background-color","rgb(235, 235, 228)"); // readonly 
		$("[name='cf_1062']").attr("readonly",true).css("background-color","rgb(235, 235, 228)"); // readonly 
		$("[name='cf_1058']").attr("readonly",true).css("background-color","rgb(235, 235, 228)"); // readonly 


		//Bloqueamos los campos que se calcularan automaticamente
		$("#Assets_editView_fieldName_cf_1076").attr("readonly",true).css("background-color","rgb(235, 235, 228)"); // readonly 
		$("#Assets_editView_fieldName_cf_1074").attr("readonly",true).css("background-color","rgb(235, 235, 228)"); // readonly 

		//Calculamos Colocación Neta
		$("#Assets_editView_fieldName_cf_1082, #Assets_editView_fieldName_cf_1084, #Assets_editView_fieldName_cf_1086, [name='cf_1096'], [name='cf_1080']").change(this.calcularColNeta);
		
		//Calculamos VAF
		$("#Assets_editView_fieldName_cf_1082, #Assets_editView_fieldName_cf_1084, #Assets_editView_fieldName_cf_1086, #Assets_editView_fieldName_cf_1094, #Assets_editView_fieldName_cf_1092,[name='cf_1096'], [name='cf_1080'], #Assets_editView_fieldName_cf_1090").change(this.calcularVAF);
		
				
	},

	calcularColNeta: function(){
		let ce = $("[name='cf_1096']").val();
		let tipomoneda = $("[name='cf_1080']").val();
		
		let tipocambio = parseFloat($("#Assets_editView_fieldName_cf_1082").val() ) ;
		//Validamos si es nan 
		tipocambio = isNaN(tipocambio) ? 0 : tipocambio;

		let precio = parseFloat ( $("#Assets_editView_fieldName_cf_1086").val() );
		let cuotainicial = parseInt($("#Assets_editView_fieldName_cf_1084").val() );


		//variables Generales
		let colneta = 0;
		let calculo = 0;

		//Cuando se verdadero dependiente de el tipo moneda
		let colneta_tipomoneda_verdadero = (precio/1.18);
		//Cuando se falso dependiente de el tipo moneda
		let colneta_tipomoneda_falso = (precio*(1-(cuotainicial)/100)/1.18);

		if(tipomoneda == 'MN'){

			//Validamos si es verdaero o falso
			calculo = ce == 'VERDADERO' ? colneta_tipomoneda_verdadero : colneta_tipomoneda_falso;

			//Cual sea el vlaor lo dividimos en entre 
			colneta = calculo / tipocambio;
		}else{
			
			//Validamos si es verdaero o falso
			calculo = ce == 'VERDADERO' ? colneta_tipomoneda_verdadero : colneta_tipomoneda_falso;

			//Seteamos el valor de col neta
			colneta = calculo;
	
		}

		//console.log("Col_neta",colneta);

		//seteamos col si es mayor a 0
		if(colneta > 0){
			$("#Assets_editView_fieldName_cf_1076").val(colneta.toFixed(0));
		}

	},

	calcularVAF: function(){
		let ce = $("[name='cf_1096']").val();
		let tipomoneda = $("[name='cf_1080']").val();
		
		let tipocambio = parseFloat($("#Assets_editView_fieldName_cf_1082").val() ) ;
		//Validamos si es nan 
		tipocambio = isNaN(tipocambio) ? 0 : tipocambio;

		let precio = parseFloat ( $("#Assets_editView_fieldName_cf_1086").val() );
		let grc = parseFloat ( $("#Assets_editView_fieldName_cf_1094").val() );
		let gasto = parseFloat ( $("#Assets_editView_fieldName_cf_1092").val() );

		//Tipo porcentaje
		let cuotainicial = parseInt($("#Assets_editView_fieldName_cf_1084").val() ) / 100;
		let tea = parseInt($("#Assets_editView_fieldName_cf_1090").val() ) / 100;

		//Variables Generales
		let calculo = 0;
		let vaf = 0;

		//Formula para tipo de cambio tipo verdadero no importa el tipo moneda
		let vaf_tipomoneda_verdadero =  (precio/1.18)+gasto+((precio/1.18)+gasto)*(tea/12)*grc;
		//Formula para tipo de cambio tipo falso no importa el tipo moneda
		let vaf_tipomoneda_falso =  (precio*(1-cuotainicial)/1.18)+gasto+(((precio*(1-cuotainicial)/1.18)+gasto)* tea / 12 * grc);

		if(tipomoneda == 'MN'){
			
			//Validamos cuando sea VERDADERO O FALSO
			calculo = ce == 'VERDADERO' ? vaf_tipomoneda_verdadero : vaf_tipomoneda_falso;
		
			//Cual sea el vlaor lo dividimos en entre 
			vaf = calculo / tipocambio;
		}else{
			
			//Vañidamos cuando sea verdaro o falso
			calculo = ce == 'VERDADERO' ? vaf_tipomoneda_verdadero : vaf_tipomoneda_falso;

			//Seteamos el valor de col neta
			vaf = calculo;
	
		}

		//seteamos VAF si es mayor a 0
		if(vaf > 0){
			$("#Assets_editView_fieldName_cf_1074").val(vaf.toFixed(0));
		}
	},

	registerBasicEvents: function (container) {
		this._super(container);
		this.initAssets(container);
	}
})