/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Vtiger_Edit_Js("Campaigns_Edit_Js",{
   
},{
	getRecordId : function(container){
		return jQuery('input[name="record"]',container).val();
	},
	initCampaigns : function(container) {

		this.getUsers(container);

	},

	getParameter : function(param) {
		const queryString = window.location.search;
		const urlParams = new URLSearchParams(queryString);
		return urlParams.get(param);
	},

	getUsers : function(container) {
		$.field_asignar_a = 'cf_1001';

		var elem_asignar_a = $("[name='"+$.field_asignar_a+"']", container);
		var asignar_a = $("[name='"+$.field_asignar_a+"[]']", container);
		asignar_a.val(null).trigger("change");
		asignar_a.empty();

		var record = this.getRecordId(container);
		if ( this.getParameter('isDuplicate') ) {
			record = this.getParameter('record');
		}

		var params = {
			module: 'Vtiger',
			action: 'GetUsers',
			source_module: 'Campaigns',
			record: record,
		};
		app.helper.showProgress();
		app.request.post({data: params}).then(function (err, res) {
			app.helper.hideProgress();
			if ( res.asignados == "" || res.asignados == null ) {
				$.asignados_selected = [];
			} else {
				$.asignados_selected = (res.asignados).split(" |##| ");
			}

			var users = res.users;
			var option = '';
			for(i in users) {
				var selected = '';
				if ( $.inArray(users[i].id, $.asignados_selected) !== -1 ) selected = "selected";
				option = `<option value="`+users[i].id+`" `+selected+`>`+users[i].first_name+` `+users[i].last_name+` (`+users[i].rolename+`)</option>`;
				asignar_a.append(option);
			}
			asignar_a.trigger("change");
				// asignar_a.html(options);
		});
	},
	
	/**
	 * Function which will register basic events which will be used in quick create as well
	 *
	 */
	registerBasicEvents : function(container) {
		this._super(container);
		this.initCampaigns(container);
	}
});