/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
Vtiger_Edit_Js("Dealercontact_Edit_Js", {}, {
    setUbigeo: function(crmid) {
        var url = "index.php?module=Vtiger&action=GetData&record=" + crmid + "&source_module=Ubigeo";
        app.helper.showProgress();
        app.request.get({ "url": url }).then(
            function(err, data) {
                app.helper.hideProgress();
                if (err === null) {
                    console.log("data", data)
                    if (data.success) {
                        var obj = data.data;
                        $("#Dealercontact_editView_fieldName_dealercontact_tks_distrito").val(obj.ubigeo_tks_distrito);
                        $("#Dealercontact_editView_fieldName_dealercontact_tks_provincia").val(obj.ubigeo_tks_provincia);
                        $("#Dealercontact_editView_fieldName_dealercontact_tks_departamento").val(obj.ubigeo_tks_departamento);
                    } else {
                        app.helper.showErrorNotification({ "message": data.message });
                    }
                } else {
                    app.helper.showErrorNotification({ "message": err });
                }
            });
    },

    initDealerContact: function(container) {
        console.log("initDealerContact");
        $('[name="dealercontact_tks_movil"]').change(function() {
            var cel = $(this).val().length;
            //console.log(cel);
            if (cel < 11) {
                alert("Porfavor escriba un Nro de Celular valido");
                $('[name="dealercontact_tks_movil"]').focus()
            } else {

            }
        });

        const mobile = document.getElementById('Dealercontact_editView_fieldName_dealercontact_tks_movil');
        mobile.onpaste = e => e.preventDefault();
        $('[name="dealercontact_tks_movil"]').keyup(function(e) {
            var nro = $(this).val();
            if (nro.length > 11) {
                $('[name="dealercontact_tks_movil"]').val("");
            }
            console.log("nro", nro);
        });
        // $('#Contacts_editView_fieldName_mobile').inputFilter(this.validarcampo9espaciosFormat);

        $("#Dealercontact_editView_fieldName_dealercontact_tks_distrito").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly ubigeo
        $("#Dealercontact_editView_fieldName_dealercontact_tks_provincia").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly ubigeo
        $("#Dealercontact_editView_fieldName_dealercontact_tks_departamento").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly ubigeo


    },

    validarcampo9espaciosFormat: function(value) {
        // Acepta solo números y 2 como máximo
        var registro = /^[0-9]{0,9}$/;
        // var registro = /^[9][0-9]/;
        return registro.test(value);
    },

    registerBasicEvents: function(container) {
        console.log("eeee");
        this._super(container);
        this.initDealerContact(container);
    }
})