/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Vtiger_Edit_Js("Potentialfield_Edit_Js", {
    /**
     * Se ejecuta al cargarse la vista de lista
     */

    initVistaLista: function() {
        $(document).ready(function() {
            var filtro = $("#currentSearchParams").val();
            var parsedFiltro = JSON.parse(filtro);
            //Llena el filtro Campo
            if (app.getViewName() == 'List' && app.getModuleName() == 'Potentialfield') {
                var params = {
                    'module': 'Potentialfield',
                    'action': 'getFilterFields'
                }
                app.helper.showProgress();
                app.request.post({ data: params }).then(function(err, result) {
                    app.helper.hideProgress();
                    if (!err && result.data) {
                        let selected = "";
                        if (parsedFiltro.potentialfield_tks_campo) {
                            selected = parsedFiltro.potentialfield_tks_campo.searchValue.split(",");
                        }

                        var opt = '<option value="">Seleccione una opción</option>';
                        $.each(result.data, function(index, value) {
                            let s = selected.includes(index) ? "selected" : null;
                            opt += "<option " + s + " value='" + index + "'>" + value + "</option>";
                        });

                        $('select[name=potentialfield_tks_campo]').html(opt).select2();
                    }
                });

                var params = {
                    'module': 'Potentialfield',
                    'action': 'getBlocks'
                }
                app.helper.showProgress();
                app.request.post({ data: params }).then(function(err, result) {
                    app.helper.hideProgress();
                    if (!err && result.data) {
                        let selected = "";
                        if (parsedFiltro.block) {
                            selected = parsedFiltro.block.searchValue.split(",");
                        }

                        var opt = '<option value="">Seleccione una opción</option>';
                        $.each(result.data, function(index, value) {
                            console.log(selected.includes(index));
                            let s = selected.includes(index) ? "selected" : null;
                            opt += "<option " + s + " value='" + index + "'>" + value + "</option>";
                        });

                        $('select[name=block]').html(opt).select2();
                    }
                });

            }
        });

    }
}, {
    initPotentialfield: function(container) {
        // A $( document ).ready() block.
        $(document).ready(function() {
            $('select[name=potentialfield_tks_campo] option[value=NO_DATA]').remove();
            $('select[name=potentialfield_tks_campo]').select2();
            $(document).on('change', 'select[name=potentialfield_tks_tipodeoportunidad]', function() {
                if ($(this).val() != '') {
                    var params = {
                        'module': 'Potentialfield',
                        'action': 'getFields',
                        'tipo': $(this).val(),
                        'record': $('input[name=record]').val()
                    }
                    app.helper.showProgress();
                    app.request.post({ data: params }).then(function(err, result) {
                        app.helper.hideProgress();
                        if (!err && result.data) {
                            var opt = '<option value="">Seleccione una opción</option>';
                            $.each(result.data, function(index, value) {
                                opt += "<option value='" + index + "'>" + value + "</option>";
                            });

                            $('select[name=potentialfield_tks_campo]').html(opt);
                            $('select[name=potentialfield_tks_campo]').val(result.selected).select2();
                        }
                    });
                }

            });

            /**
             * Obtiene todos los bloques del módulo
             */

            var params = {
                'module': 'Potentialfield',
                'action': 'getBlocks',
                'record': $('input[name=record]').val()
            }
            app.helper.showProgress();
            app.request.post({ data: params }).then(function(err, result) {
                app.helper.hideProgress();
                if (!err && result.data) {
                    var opt = '<option value="">Seleccione una opción</option>';
                    $.each(result.data, function(index, value) {
                        opt += "<option value='" + index + "'>" + value + "</option>";
                    });

                    $('select[name=block]').html(opt);
                    $('select[name=block]').val(result.selected).select2();

                }
            });

            var record = $('input[name=record]').val();
            if (record > 0) $('select[name=potentialfield_tks_tipodeoportunidad]').change();

        });
    },

    /**
     * Function which will register basic events which will be used in quick create as well
     *
     */
    registerBasicEvents: function(container) {
        this._super(container);
        this.initPotentialfield(container);
    }
});

Potentialfield_Edit_Js.initVistaLista();
