{*+**********************************************************************************
* The contents of this file are subject to the vtiger CRM Public License Version 1.1
* ("License"); You may not use this file except in compliance with the License
* The Original Code is: vtiger CRM Open Source
* The Initial Developer of the Original Code is vtiger.
* Portions created by vtiger are Copyright (C) vtiger.
* All Rights Reserved.
************************************************************************************}
{* modules/Vtiger/views/MassActionAjax.php *}
    
{* START YOUR IMPLEMENTATION FROM BELOW. Use {debug} for information *}
{strip}
    <div class="modal-dialog">
        <div class="modal-content" id="form_Trans">
            <form class="form-horizontal" id="formTrans" name="formTrans" method="post" action="index.php">
                
                <input type="hidden" name="action" value="sendTransaccionalData" />
                <input type="hidden" name="module" value="Potentials" />
                <input type="hidden" name="record" value="{$RECORD->getId()}" />
            
                <div class="modal-header">
                    <div class="clearfix">
                        <div class="pull-right " >
                            <button type="button" class="close" aria-label="Close" data-dismiss="modal">
                                <span aria-hidden="true" class='fa fa-close'></span>
                            </button>
                        </div>
                        <h4 class="pull-left" id="titulo_tranferencia">
                            Enviar datos a Transaccional
                        </h4>
                    </div>
                </div>
                
                <div class="modal-body">
                    <legend>Datos de Cliente</legend>
                    <div class="form-group">
                            <label class="col-lg-4 control-label">Tipo de Documento</label>
                            <div class="col-lg-6"><input class="inputElement" id="tipo_documento" readonly value="RUC"></div>
                    </div>
                    <div class="form-group">
                            <label class="col-lg-4 control-label">Nombre / Razón Social</label>
                            <div class="col-lg-6"><input class="inputElement" id="nombre_rz" readonly value="{if $ACCOUNTS neq ''}{$ACCOUNTS->get('accountname')}{/if}"></div>
                    </div>
                    <div class="form-group">
                            <label class="col-lg-4 control-label">Domicilio Legal *</label>
                            <div class="col-lg-6"><input class="inputElement" id="domicilio_legal" name='bill_street' required value="{if $ACCOUNTS neq ''}{$ACCOUNTS->get('bill_street')}{/if}"></div>
                    </div>
                    <legend>Datos de la Operación</legend>
                    <div class="form-group">
                            <label class="col-lg-4 control-label">Responsable</label>
                            <div class="col-lg-6"><input class="inputElement" id="" readonly value="{$ASSIGNED_TO->get('first_name')} {$ASSIGNED_TO->get('last_name')}"></div>
                    </div>
                    <div class="form-group">
                            <label class="col-lg-4 control-label">Correo del Responsable</label>
                            <div class="col-lg-6"><input class="inputElement" id="" readonly value="{$ASSIGNED_TO->get('email1')}"></div>
                    </div>
                    <div class="form-group">
                            <label class="col-lg-4 control-label">Moneda</label>
                            <div class="col-lg-6"><input class="inputElement" id="" readonly value="{$RECORD->get('moneda')}"></div>
                    </div>
                    <div class="form-group">
                            <label class="col-lg-4 control-label">Producto</label>
                            <div class="col-lg-6"><input class="inputElement" id="" readonly value="{$RECORD->get('opportunity_type')}"></div>
                    </div>
                    <div class="form-group">
                            <label class="col-lg-4 control-label">Línea Solicitada</label>
                            <div class="col-lg-6"><input class="inputElement" id="" readonly value="{$RECORD->get('cf_1026')}"></div>
                    </div>
                
                {if $CONTACTS neq ''}
                    <legend>Contactos</legend>
                    {foreach from=$CONTACTS item=CONTACT key=KEY}
                        <input type="hidden" name="contact[{$KEY}]" value ="{$CONTACT->getId()}">
                        <div class="form-group">
                            <label class="col-lg-4 control-label">Nombre completo</label>
                            <div class="col-lg-6"><input class="inputElement" readonly name="nombre[{$KEY}]" value="{$CONTACT->get('firstname')} {$CONTACT->get('lastname')}"></div>
                        </div>
                        <div class="form-group">
                                <label class="col-lg-4 control-label">Documento</label>
                                <div class="col-lg-6"><input class="inputElement" name="documento[{$KEY}]" required value="{$CONTACT->get('nrodocumento')}"></div>
                        </div>
                        <div class="form-group">
                                <label class="col-lg-4 control-label">Correo Electrónico</label>
                                <div class="col-lg-6"><input class="inputElement" name="email[{$KEY}]" required value="{$CONTACT->get('email')}"></div>
                        </div>
                        <div class="form-group">
                                <label class="col-lg-4 control-label">Teléfono</label>
                                <div class="col-lg-6"><input class="inputElement" name="telefono[{$KEY}]" required value="{$CONTACT->get('mobile')}"></div>
                        </div>
                        <hr>
                    {/foreach}
                {/if}
                </div>
                <div class="modal-footer ">
                    <center>
                        <button class="btn btn-success" type="submit" id="btnEnviar"><strong>Transferir</strong></button>
                        <a class="btn btn-default cancelLink" type="reset" id="btnCancelar" data-dismiss="modal"><strong>Cancelar</strong></a>
                    </center>
                </div>
            </form>
        </div>
    </div>

{/strip}
{literal}
<script type="text/javascript">
$(document).ready(function(){
    function getFormData($form){
        var unindexed_array = $form.serializeArray();
        var indexed_array = {};

        $.map(unindexed_array, function(n, i){
            indexed_array[n['name']] = n['value'];
        });

        return indexed_array;
    }

    $(document).on('submit','#formTrans',function(e){
        e.preventDefault();
        app.helper.showConfirmationBox({'message' : '¿Desea enviar estos datos al Sistema Transaccional?'}).then(
            function(e) {
                var $form = $('#formTrans');
                var params = getFormData($form);
                app.helper.showProgress();
                app.request.post({"data":params}).then(function(err,data){
                    app.helper.hideProgress();
                    if(!err)
                    {
                        $('#btnCancelar').click();
                        if(data.data == 2) //Op exitosa
                        {
                            app.helper.showSuccessNotification({message: app.vtranslate('Transacción realizada satisfactoriamente.')});
                             const myTimeout = setTimeout(function(){
                                location.reload();
                             }, 5000);
                        }
                        else{
                            app.helper.showErrorNotification({message: app.vtranslate('Hubo un error. Transacción Cancelada.')});
                        }
                    }
                    
                });
            },
            function(error, err){
            }
        )
    });
});


</script>
{/literal}