/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
Vtiger_Edit_Js("Potentials_Edit_Js", {}, {



    initPotentials: function(container) {
        var thiInstance = this;
        // Si es operacion Ganada que no pueda editar nada 
        if ($("[name='sales_stage']").val() == 'Closed Won' && $("[name='opportunity_type']").val() == 'Factoring') {
            $(".saveButton").remove();
        }

        $('[name=nro_operacion]').attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly

        $(document).ready(function() {
            let nroOp = $('[name=nro_operacion]').val();
            if (nroOp) {
                $('select[name=sales_stage]').attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly
                $('select[name=sales_stage]').select2();
            }
        })

        let parametros = {
            'module': 'Vtiger',
            'action': 'getModuleRecord',
            'recordId': _USERMETA.id,
            'module_related': 'Users'
        };

        window.sessionStorage.roleid = '';
        window.sessionStorage.cbx_asignedto = $('[name=assigned_user_id]').html();
        app.request.post({ data: parametros }).then(function(err, result) {
            if (result.success) {
                window.sessionStorage.roleid = result.data.roleid;
                window.sessionStorage.asignedUsers = [];
                if (window.sessionStorage.roleid == "H14") {
                    let parametros2 = {
                        'module': 'Users',
                        'action': 'ObtenerUsuariosAsignados',
                        'recordId': _USERMETA.id
                    };

                    app.request.post({ data: parametros2 }).then(function(err, result) {
                        if (result.success) {
                            window.sessionStorage.asignedUsers = result.data.split(",");
                        }

                    });
                }
            }

        });

        //CAMBIO 01122021:MALMEYDA
        // if(app.getModuleName == "Accounts") {
        // 	console.log("VARIABLE GENERAL",_USERMETA);
        // 	//Si el usuario es diferente que la persona asignada a la cuenta no puede editar nada
        // 	var idPersonaAsig = $('#ID_ASIGNED_TO').val();
        // 	var UNIDAD_ASIGNADO = $('#UNIDAD_ASIGNADO').val();
        // 	var N_UNIDADES = $('#N_UNIDADES').val();
        // 	var ID_UNITY_USER = $('#ID_UNITY_USER').val();
        // 	var nUNITY_USER = ID_UNITY_USER.split(' |##| ').length
        // 	var idCurrentUser = _USERMETA.id;

        // 	// if(idPersonaAsig && idPersonaAsig != idCurrentUser && (N_UNIDADES > 1 || nUNITY_USER > 1 || (N_UNIDADES == 1 && UNIDAD_ASIGNADO == ID_UNITY_USER)))
        // 	// {
        // 	// 	$(".saveButton").remove();
        // 	// }
        // }


        $("[name='sales_stage']").change(function(e) {
            let fase_venta = $(this).val();
            //Si es operacion ganada que no pueda guardar


            $("#Potentials_editView_fieldName_cf_858").val("");
            $("#Potentials_editView_fieldName_nextstep").val("");
            thiInstance.obligatorioConFaseDeVenta();
            thiInstance.dependenciaTipoMotivoSubmotivo();

            //Validamos si fase de venta es cerrada o perdida 
            if (fase_venta == 'Closed Won' || fase_venta == 'Closed Lost') {
                //Enviamos la fecha de hoy FECHA ESTIMADA DE CIERRE 
                $("#Potentials_editView_fieldName_closingdate").val(thiInstance.ObtenerFechaActual());
            }
        });
        this.obligatorioConFaseDeVenta();

        $.values_submotivos = [];
        $.valores_actuales = $("#Potentials_Edit_fieldName_cf_880").val();
        if ($.valores_actuales == null) $.valores_actuales = [];
        $("#Potentials_Edit_fieldName_cf_880 option").each(function() {
            $.values_submotivos.push($(this).val());
        });

        $("[name='opportunity_type']").change(this.dependenciaTipoMotivoSubmotivo);
        $("[name='cf_878']").change(this.dependenciaTipoMotivoSubmotivo);

        $("#Potentials_editView_fieldName_cf_959").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_961").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 

        $("#Potentials_editView_fieldName_cf_992").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_994").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_996").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly

        $("#Potentials_editView_fieldName_cf_1022").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly
        $("#Potentials_editView_fieldName_cf_1024").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_1026").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 

        //Redondeamos a dos decimales el valor neto
        var totalneto = $('#Potentials_editView_fieldName_cf_1026').val();
        totalneto = isNaN(parseFloat(totalneto)) ? 0 : parseFloat(totalneto);
        totalneto = totalneto.toFixed(2);
        $("#Potentials_editView_fieldName_cf_1026").val(totalneto);

        /*MODIFICACIONES SETIEMBRE 2021*/

        /*var date_field1 = jQuery(document).find('#Potentials_editView_fieldName_cf_1028');
        date_field1.attr('readonly', true);
        date_field1.closest('div').on('mouseover', function() { date_field1.attr('disabled', true); });
        date_field1.closest('div').on('mouseout', function() { date_field1.attr('disabled', false); });
        */
        var date_field2 = jQuery(document).find('#Potentials_editView_fieldName_cf_1038');
        date_field2.attr('readonly', true);
        date_field2.closest('div').on('mouseover', function() { date_field2.attr('disabled', true); });
        date_field2.closest('div').on('mouseout', function() { date_field2.attr('disabled', false); });

        // var date_field3 = jQuery(document).find('#Potentials_editView_fieldName_cf_1086');
        // date_field3.attr('readonly', true);
        // date_field3.closest('div').on('mouseover', function() {date_field3.attr('disabled', true);});
        // date_field3.closest('div').on('mouseout', function() {date_field3.attr('disabled', false);});

        // var date_field4 = jQuery(document).find('#Potentials_editView_fieldName_cf_1088');
        // date_field4.attr('readonly', true);
        // date_field4.closest('div').on('mouseover', function() {date_field4.attr('disabled', true);});
        // date_field4.closest('div').on('mouseout', function() {date_field4.attr('disabled', false);});

        // var date_field5 = jQuery(document).find('#Potentials_editView_fieldName_cf_1090');
        // date_field5.attr('readonly', true);
        // date_field5.closest('div').on('mouseover', function() {date_field5.attr('disabled', true);});
        // date_field5.closest('div').on('mouseout', function() {date_field5.attr('disabled', false);});

        $("[name='cf_1032']").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 

        $("#Potentials_editView_fieldName_cf_1030").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_1040").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_1044").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_1046").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 

        //Cuando cambiemos el estado de riesgo APRO / COM cambia el estado de riesgo por APROBADO O EN COMITE

        $("[name='sales_stage']").change(this.CaptureMomento);
        $("[name='cf_1036']").change(this.changeFaseVenta);
        //$("[name='cf_878']").change(this.CaptureDesistida);

        //Bloqueo de nuevos campos 29-09-2021
        $("#Potentials_editView_fieldName_cf_1100").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        //$("#Potentials_editView_fieldName_cf_1102").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_1104").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_1106").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 


        $("#Potentials_editView_fieldName_cf_1114").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        /**Modificaciones 23-12-2022 */
        $("#Potentials_editView_fieldName_cf_925").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_927").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        $("#Potentials_editView_fieldName_cf_929").attr("readonly", true).css("background-color", "rgb(235, 235, 228)"); // readonly 
        //Agrega el boton para buscar RUC en sentinel
        var nombreElm = "aceptante1";
        var elmRUC = $('input[name=' + nombreElm + ']');
        var spanPadre = elmRUC.parent();
        var ruc = elmRUC.val();

        spanPadre.html('<div class="referencefield-wrapper ">' +
            '<div class="input-group">' +
            '<input data-n="1" id="Potentials_editView_fieldName_' + nombreElm + '" type="text" class="marginLeftZero inputElement inputRuc"' +
            'name="' + nombreElm + '" value="' + ruc + '">' +
            '<span class="input-group-addon cursorPointer" title="Buscar en Sentinel"><i class="buscarRUC_Sentinel fa fa-search"></i></span>' +
            '</div>' +
            '</div>');

        var nombreElm = "aceptante2";
        var elmRUC = $('input[name=' + nombreElm + ']');
        var spanPadre = elmRUC.parent();
        var ruc = elmRUC.val();
        spanPadre.html('<div class="referencefield-wrapper ">' +
            '<div class="input-group">' +
            '<input data-n="2" id="Potentials_editView_fieldName_' + nombreElm + '" type="text" class="marginLeftZero inputElement inputRuc"' +
            'name="' + nombreElm + '" value="' + ruc + '">' +
            '<span class="input-group-addon cursorPointer" title="Buscar en Sentinel"><i class="buscarRUC_Sentinel fa fa-search"></i></span>' +
            '</div>' +
            '</div>');

        var nombreElm = "aceptante3";
        var elmRUC = $('input[name=' + nombreElm + ']');
        var spanPadre = elmRUC.parent();
        var ruc = elmRUC.val();
        spanPadre.html('<div class="referencefield-wrapper ">' +
            '<div class="input-group">' +
            '<input data-n="3" id="Potentials_editView_fieldName_' + nombreElm + '" type="text" class="marginLeftZero inputElement inputRuc"' +
            'name="' + nombreElm + '" value="' + ruc + '">' +
            '<span class="input-group-addon cursorPointer" title="Buscar en Sentinel"><i class="buscarRUC_Sentinel fa fa-search"></i></span>' +
            '</div>' +
            '</div>');

        $(document).on('click', '.buscarRUC_Sentinel', function() {
            var elmRUC = $(this).closest('div.input-group').find('.inputRuc');
            var n = elmRUC.data('n');
            let ruc = elmRUC.val();
            console.log(ruc);
            if (ruc) {
                var params = {
                    'module': 'Accounts',
                    'action': 'getSentinelData',
                    'ruc': ruc
                }
                app.helper.showProgress();
                app.request.post({ data: params }).then(function(err, result) {
                    if (!err) {
                        app.helper.hideProgress();
                        if (result.data) {
                            let string_ = JSON.parse(result.data);
                            let data = string_.result;
                            console.log(string_);
                            switch (n) {
                                case 1:
                                    $('input[name=cf_925]').val(data.razon_social);
                                    break;
                                case 2:
                                    $('input[name=cf_927]').val(data.razon_social);
                                    break;
                                case 3:
                                    $('input[name=cf_929]').val(data.razon_social);
                                    break;
                            }

                        } else {
                            var options = {
                                message: "No se encontraron datos.",
                                title: 'No hay datos de este RUC.'
                            }
                            var settings = {
                                'delay': 0
                            };
                            app.helper.showErrorNotification(options, settings);
                        }
                    }
                });
            }
        });

        $(document).on('change','input[name=cf_1102],input[name=cf_1009],input[name=nro_unidades]', function () {
            var tipoOp = $('select[name=opportunity_type]').val();
            var gasto = isNaN(parseFloat($('input[name=cf_1102]').val())) ? 0: parseFloat($('input[name=cf_1102]').val());
            var colocacion_neta = 0;
            var VAF = 0;
            var valorBruto = $('input[name=cf_949]').val();
            var cuotaIni = $('input[name=cf_1009]').val();
            var InicialBruta = valorBruto*(cuotaIni/100);
            var numeroUnidades = $('input[name=nro_unidades]').val();
            debugger;
           switch (tipoOp) {
                case 'Credito Directo':
                case 'Crédito Mediano Plazo':
                    colocacion_neta = (valorBruto - cuotaIni + gasto) * numeroUnidades;
                    VAF = colocacion_neta;
                   break;
           
               case 'Leasing':
                    colocacion_neta = (valorBruto/1.18 - InicialBruta/1.18)*numeroUnidades;
                    VAF = (valorBruto/1.18 - InicialBruta/1.18 + gasto)*numeroUnidades;
                   break;
           }

           $('input[name=cf_1106]').val(colocacion_neta.toFixed(2));
           $('input[name=cf_1104]').val(VAF.toFixed(2));

        });
    },
    ObtenerFechaActual: function() {
        var f = new Date();
        var fechaactual = "";
        //document.write(f.getDate() + "" + (f.getMonth() +1) + "/" + f.getFullYear());
        var dia = f.getDate();
        var mes = f.getMonth() + 1;
        var ano = f.getFullYear();

        dia = dia < 10 ? '0' + dia : dia;
        mes = mes < 10 ? '0' + mes : mes;

        $fechaactual = dia + "-" + mes + "-" + ano;
        return $fechaactual;
    },

    dependenciaTipoMotivoSubmotivo: function() {
        var tipo = $("[name='opportunity_type']").val();
        var motivo = $("[name='cf_878']").val();
        var elm_submotivo = $("[name='cf_880']");
        var valores = $.values_submotivos;
        if (tipo == 'Leasing') {
            if (motivo == 'Rechazado - Riesgos' || motivo == 'Rechazado - Comercial') {
                valores = ["Carácter", "Condición", "Capital", "Capacidad", "Colateral", "Otros"];
            } else if (motivo == 'Desistida') {
                valores = ["Cerro con Otro Banco", "Condiciones de Aprobación", "Perdio el Frente", "Compro al Contado", "Vendio la Maquina", "Otros"];
            } else if (motivo == 'Desestimada') {
                valores = ["Sin Perfil", "No Interesado", "Busca Invertir", "No Responde", "Busca Informacion", "Numero Equivocado", "Busca Otro Credito", "No Califica para la Campaña", "Otros"];
            }
        } else if (tipo == 'Factoring') {
            if (motivo == 'Rechazada') {
                valores = ["Carácter", "Condición", "Capital", "Capacidad", "Colateral", "Perfil de Aceptante", "Otros"];
            } else if (motivo == 'Desistida') {
                valores = ["Cerro con otra entidad", "Tiempo de desembolso", "Condiciones de Aprobación", "Perdio el Frente", "Aceptante no aceptó la negociación", "Compro al Contado", "Vendio la Maquina", "Otros"];
            } else if (motivo == 'Desestimada') {
                valores = ["Sin Perfil", "No Interesado", "Busca Invertir", "No Responde", "Busca Informacion", "Numero Equivocado", "Busca Otro Credito", "No Califica para la Campaña", "El deudor no califica", "Otros"];
            }
        }

        // if ( $.valores_actuales.length > 0 ) valores = $.valores_actuales;

        $("#Potentials_Edit_fieldName_cf_880").val(null).trigger("change");
        $("#Potentials_Edit_fieldName_cf_880").empty();
        for (i in valores) {
            option = `<option value="` + valores[i] + `">` + valores[i] + `</option>`;
            $("#Potentials_Edit_fieldName_cf_880").append(option);
        }
    },

    obligatorioConFaseDeVenta: function() {
        var fase = $("[name='sales_stage']").val();
        if (fase == 'Closed Won' || fase == 'Closed Lost') {
            // $("#Potentials_editView_fieldName_cf_858").removeAttr("required");
            // $("#Potentials_editView_fieldName_nextstep").removeAttr("required");
        } else {
            // $("#Potentials_editView_fieldName_cf_858").attr("required", true);
            // $("#Potentials_editView_fieldName_nextstep").attr("required", true);
        }
    },

    changeFaseVenta: function() {

        //Estado de riesgo
        let EstadoRiesgo = $("[name='cf_1036']").val();

        //Obtiene Fecha Actual
        let Hoy = new Date();
        let FechaActual = Hoy.getDate() + '-' + (Hoy.getMonth() + 1) + '-' + Hoy.getFullYear();
        //Obtiene la hora completa actual
        let HoraCompletaActual = Hoy.getHours() + ':' + Hoy.getMinutes() + ':' + Hoy.getSeconds();



        switch (EstadoRiesgo) {
            case 'APROBADO':
                $("[name='sales_stage']").val('Aprobada').trigger('change');

                //Captura Momento
                $("[name='cf_1038']").val(FechaActual);
                $("[name='cf_1040']").val(HoraCompletaActual);
                break;

            case 'COMITE DE RIESGO':
                $("[name='sales_stage']").val('En Comite').trigger('change');
                break;

            case 'RECHAZADO':
                $("[name='sales_stage']").val('Closed Lost').trigger('change');
                //$("[name='cf_1088']").val(FechaActual);
                break;
        }

        //alert(EstadoRiesgo);

    },

    CaptureMomento: function() {
        var Hoy = new Date();
        let FechaActual = Hoy.getDate() + '-' + (Hoy.getMonth() + 1) + '-' + Hoy.getFullYear();

        let HoraActual = Hoy.getHours();

        //Obtiene la hora completa actual
        let HoraCompletaActual = Hoy.getHours() + ':' + Hoy.getMinutes() + ':' + Hoy.getSeconds();

        //Solo si es ingreso a riesgos calculamos estos campos

        if ($(this).val() == 'Ingreso a Riesgos') {

            if (HoraActual >= 8 && HoraActual <= 12) {
                //alert("Mañana"+HoraActual);
                $("[name='cf_1032']").val('Mañana').trigger('change');
                //$("[name='cf_1078']").val(FechaActual);
            } else {
                //alert("tarde"+HoraActual);
                $("[name='cf_1032']").val('Tarde').trigger('change');
            }

            //Cuando ingrese a reisgos el primer estado es cola

            $("[name='cf_1036']").val('COLA').trigger('change');
            //Obtenemos la Hora y Fecha Actual
            $("[name='cf_1028']").val(FechaActual);
            $("[name='cf_1030']").val(HoraCompletaActual);
        }

        // else if($(this).val() == 'Closed Won'){
        // 	$("[name='cf_1086']").val(FechaActual);		
        // }


        //alert( HoraActual);
    },

    CaptureDesistida: function() {
        var Hoy = new Date();
        let FechaActual = Hoy.getDate() + '-' + (Hoy.getMonth() + 1) + '-' + Hoy.getFullYear();

        let HoraActual = Hoy.getHours();

        //Obtiene la hora completa actual
        let HoraCompletaActual = Hoy.getHours() + ':' + Hoy.getMinutes() + ':' + Hoy.getSeconds();

        //Solo si es ingreso a riesgos calculamos estos campos

        if ($(this).val() == 'Desistida') {
            //Obtenemos la Hora y Fecha Actual
            $("[name='cf_1090']").val(FechaActual);
            //$("[name='cf_1074']").val(HoraCompletaActual);
        }
    },

    registerBasicEvents: function(container) {
        this._super(container);
        this.initPotentials(container);
    }
})