/*********************************************************************************
 * The content of this file is subject to the ITS4YouKanbanView license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

Settings_Vtiger_List_Js("Settings_ITS4YouKanbanView_Edit_Js", {}, {
    registerModuleChangeEvent : function() {
        var thisInstance = this;
        jQuery('#pickListModules').on('change',function(e){
            var selectedModule = jQuery(e.currentTarget).val();
            if(selectedModule.length <= 0) {
                app.helper.showErrorNotification({message: app.vtranslate('JS_PLEASE_SELECT_MODULE')});
                return;
            }
            var params = {
                module : app.getModuleName(),
                parent : app.getParentModuleName(),
                source_module : selectedModule,
                view : 'IndexAjax',
                mode : 'getPickListDetailsForModule'
            };

            app.helper.showProgress();
            app.request.post({data: params}).then(function(error, data){
                jQuery('#modulePickListContainer').html(data);
                app.helper.hideProgress();
                vtUtils.showSelect2ElementView(jQuery('#modulePickListContainer').find('select.select2'));
                thisInstance.registerModulePickListChangeEvent();
                jQuery('#modulePickList').trigger('change');
            });
        });
    },
    registerModulePickListChangeEvent : function() {
        var thisInstance = this;
        jQuery('#modulePickList').on('change',function(e){
            var params = {
                module : app.getModuleName(),
                parent : app.getParentModuleName(),
                source_module : jQuery('#pickListModules').val(),
                view : 'IndexAjax',
                mode : 'getPickListValueForField',
                pickListFieldId : jQuery(e.currentTarget).val()
            };

            app.helper.showProgress();
            app.request.post({data: params}).then(function (error, data) {
                jQuery('#modulePickListValuesContainer').html(data);
                vtUtils.showSelect2ElementView(jQuery('#role2picklist'));
                app.helper.hideProgress();
                // thisInstance.showPicklistValues();
                thisInstance.saveEnabledPicklistValues();
                thisInstance.registerBackClickEvent();
            });
        });
    },
    saveEnabledPicklistValues: function () {
        jQuery('#saveOrder').on('click',function(e) {
            var pickListValues = jQuery('#role2picklist option');
            var selectedValues = jQuery('#role2picklist').val();

            var enabledValues = [];
            jQuery.each(pickListValues,function() {
                var currentValue = jQuery(this);
                if(selectedValues && jQuery.inArray(currentValue.val(), selectedValues) > -1){
                    enabledValues.push(currentValue.data('id'));
                }
            });

            app.helper.showProgress();

            var params = {
                module : app.getModuleName(),
                parent : app.getParentModuleName(),
                action : 'SaveAjax',
                mode : 'savePicklistValues',
                enabled_values : enabledValues,
                picklistName : jQuery('[name="modulePickList"]').val(),
                selectedModule: jQuery('#pickListModules').val()
            };

            app.request.post({data: params}).then(function(error, data) {
                app.helper.hideProgress();
                if (error === null) {
                    app.helper.showSuccessNotification({message: app.vtranslate('JS_KANBAN_SETTINGS_SAVED_SUCCESSFULLY')});
                } else {
                    app.helper.showErrorNotification({message: app.vtranslate('JS_KANBAN_SETTINGS_NOT_SAVED')});
                }
            });
        });
    },
    registerBackClickEvent: function () {
        jQuery('#backLink').on('click', function (e) {
            const url = jQuery(e.currentTarget).data('backurl');
            window.location.href = url;
        });
    },
    registerEvents : function() {
        this.registerModuleChangeEvent();

        jQuery('#pickListModules').trigger('change');
    }
});
