<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Accounts_SearchRUC_Action extends Vtiger_IndexAjax_View {

	public function process(Vtiger_Request $request) {
		global $adb, $site_URL, $PORTAL_URL,$current_user;
		

		//Respuesta generales
		$rpt = false;
		$micuenta = false;
		$asignado = "";

		//Obtenemos el ruc
		$rutcliente  = $request->get('ruc');
		//$rutcliente  = '20605791060';

		//Obtenemos al usuarios 

		if( !empty($rutcliente) ){
			$rs_cuenta = $adb->pquery("SELECT *FROM vtiger_account a
										INNER JOIN vtiger_crmentity e ON e.crmid = a.accountid AND e.deleted = 0
										WHERE a.siccode = ?",array($rutcliente));

		}

		//Obtenemos el modelo 
		if($adb->num_rows($rs_cuenta) > 0){
			//Obtenemos los datos de la cuenta 
			$cuenta = Vtiger_Record_Model::getInstanceById($adb->query_result($rs_cuenta,0,'accountid'), 'Accounts')->getData();

			//Obtenemos al usuario logueado
			$user_login = Vtiger_Record_Model::getInstanceById($current_user->id, 'Users')->getData();

			//Validamos si es el mismo asginado 
			if($current_user->id == $cuenta['assigned_user_id']){$micuenta = true;}

			//Obtenemos al asignado a de la cuenta 
			$asignado_cuenta = Vtiger_Record_Model::getInstanceById($cuenta['assigned_user_id'], 'Users')->getData();
			$asignado = $asignado_cuenta['first_name'].' '.$asignado_cuenta['last_name'];

			$rpt = true;
			//var_dump(array('success' => $response, 'micuenta' => $micuenta,'data'=> $asignado));

		}

		$response = new Vtiger_Response();
		$response->setResult(array('success' => $rpt, 'micuenta' => $micuenta ,'data' => $asignado));
		$response->emit();

		//var_dump(array('success' => $response, 'micuenta' => $micuenta,'data'=> $asignado));



	}
}
