<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
/*
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

class Accounts_TransferOwnership_Action extends Vtiger_Action_Controller {
	
	function checkPermission(Vtiger_Request $request) {
		$moduleName = $request->getModule();
		$moduleModel = Vtiger_Module_Model::getInstance($moduleName);
		$currentUserPriviligesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();

		if(!$currentUserPriviligesModel->hasModuleActionPermission($moduleModel->getId(), 'Save')) {
			throw new AppException(vtranslate($moduleName, $moduleName).' '.vtranslate('LBL_NOT_ACCESSIBLE'));
		}
	}

	public function process(Vtiger_Request $request) {
		$module = $request->getModule();
		$moduleModel = Vtiger_Module_Model::getInstance($module);
		$transferOwnerId = $request->get('transferOwnerId');
		$record = $request->get('record');
		$currentUserModel = Users_Record_Model::getCurrentUserModel();

		if(empty($record))
			$recordIds = $this->getBaseModuleRecordIds($request);
		else
			$recordIds[] = $record;
		
		$countR = count($recordIds);
		#var_dump($countR);
		#Si no es admin se verifica si el usuario que desea mover los registros es subordinado
		if(!$currentUserModel->isAdminUser())
			$this->filtrarRegistros_Subordinados($recordIds,$module);
		
		#var_dump(count($recordIds)); die;
		
		$relatedModuleRecordIds = $moduleModel->getRelatedModuleRecordIds($request, $recordIds);
		foreach ($recordIds as $key => $recordId) {
			array_push($relatedModuleRecordIds, $recordId);
		}
		array_merge($relatedModuleRecordIds, $recordIds);
		//malmeyda
		//$result = $moduleModel->transferRecordsOwnership($transferOwnerId, $relatedModuleRecordIds);
		$result = $moduleModel->Transferir_ejecutivos($transferOwnerId, $relatedModuleRecordIds);
		$response = new Vtiger_Response();
		if ($result === true) {
			if(empty($recordIds)){ $result_['result'] = 3; }
			elseif($countR != count($recordIds)){ $result_['result'] = 2; }
			else { $result_['result'] = 1; }

			$response->setResult($result_);
		} else {
			$response->setError($result);
		}
		$response->emit();
	}
	
	public function filtrarRegistros_Subordinados(&$recordIds,$moduleName)
	{
		global $adb, $current_user;
		#Array que guarda la relacion de usuarios con su supervisor para optimizar la búsqueda.
		$Usuario_ReportaA = [];
		foreach ($recordIds as $k => $recordId) {
			if(!Users_Privileges_Model::isPermitted($moduleName, 'Save', $recordId))
			{
				unset($recordIds[$k]);
				continue;
			}else{
				$recordModel = Vtiger_Record_Model::getInstanceById($recordId)->getData();
				$UserIdAsigned = $recordModel['assigned_user_id'];
				if(!isset($Usuario_ReportaA[$UserIdAsigned]))
				{
					$resultQ = $adb->pquery("SELECT reports_to_id FROM vtiger_users WHERE id = ?",[$UserIdAsigned]);
					$idReportaA = $adb->query_result($resultQ,0,'reports_to_id');
					if(!empty($idReportaA)){
						$Usuario_ReportaA[$UserIdAsigned] = $idReportaA;
						if($idReportaA != $current_user->id){
							unset($recordIds[$k]);
							continue;
						}
					} 
					
				}
				else{
					if($Usuario_ReportaA[$UserIdAsigned] != $current_user->id){
						unset($recordIds[$k]);
						continue;
					}
				}
			}
		}
	}

	protected function getBaseModuleRecordIds(Vtiger_Request $request) {
		$cvId = $request->get('viewname');
		$module = $request->getModule();
		$selectedIds = $request->get('selected_ids');
		$excludedIds = $request->get('excluded_ids');
		if(!empty($selectedIds) && $selectedIds != 'all') {
			if(!empty($selectedIds) && count($selectedIds) > 0) {
				return $selectedIds;
			}
		}

		if($selectedIds == 'all'){
			$customViewModel = CustomView_Record_Model::getInstanceById($cvId);
			if($customViewModel) {
				$operator = $request->get('operator');
				$searchParams = $request->get('search_params');
				if (!empty($operator)) {
					$customViewModel->set('operator', $operator);
					$customViewModel->set('search_key', $request->get('search_key'));
					$customViewModel->set('search_value', $request->get('search_value'));
				}
				if (!empty($searchParams)) {
					$customViewModel->set('search_params', $searchParams);
				}
				return $customViewModel->getRecordIds($excludedIds, $module);
			}
		}
        return array();
	}
    
    public function validateRequest(Vtiger_Request $request) {
        $request->validateWriteAccess();
    }
}
