<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Campaigns_Record_Model extends Vtiger_Record_Model {

	/**
	 * Function to get selected ids list of related module for send email
	 * @param <String> $relatedModuleName
	 * @param <array> $excludedIds
	 * @return <array> List of selected ids
	 */
	public function getSelectedIdsList($relatedModuleName, $excludedIds = false) {
		$db = PearDatabase::getInstance();

		switch($relatedModuleName) {
			case "Leads"		: $tableName = "vtiger_campaignleadrel";		$fieldName = "leadid";		break;
			case "Accounts"		: $tableName = "vtiger_campaignaccountrel";		$fieldName = "accountid";	break;
			case 'Contacts'		: $tableName = "vtiger_campaigncontrel";		$fieldName = "contactid";	break;
		}

		$query = "SELECT $fieldName FROM $tableName
					INNER JOIN vtiger_crmentity ON $tableName.$fieldName = vtiger_crmentity.crmid AND vtiger_crmentity.deleted = ?
					WHERE campaignid = ?";
		if ($excludedIds) {
			$query .= " AND $fieldName NOT IN (". implode(',', $excludedIds) .")";
		}

		$result = $db->pquery($query, array(0, $this->getId()));
		$numOfRows = $db->num_rows($result);

		$selectedIdsList = array();
		for ($i=0; $i<$numOfRows; $i++) {
			$selectedIdsList[] = $db->query_result($result, $i, $fieldName);
		}
		return $selectedIdsList;
	}

	public static function getUsersByCampingId($campaignid) {
		$field_asignar_a = 'cf_1001';

		global $adb;

		$model = Vtiger_Record_Model::getInstanceById($campaignid, 'Campaigns');
		$asignados = decode_html($model->get($field_asignar_a));
		$asignados = explode(" |##| ", $asignados);

		$rs = $adb->pquery("SELECT CONCAT(u.first_name, ' ', u.last_name) as usuario 
				FROM vtiger_users u 
				inner join vtiger_user2role ur on u.id= ur.userid
				inner join vtiger_role r on ur.roleid = r.roleid
				where u.id in (". generateQuestionMarks($asignados) .")", $asignados);
		$users = array();
		while ($row = $adb->fetch_row($rs)) {
			$users[] = decode_html($row['usuario']);
		}
		// var_dump($users);die();
		return implode(", ", $users);
	}
}

