<?php 


chdir("../../");
include_once('vtlib/Vtiger/Module.php');

function createBlock($label,$instanceModule)
{
    global $adb;
    #$adb->setDebug(true);
    $blockValueMap = [
        'blocklabel' => $label,
        'display_status' => 1,
        'iscustom' => 0
    ];

    $block = new Vtiger_Block();
    $block = $block->getInstance($label,$instanceModule);
    if(empty($block))
    {   
        $block = new Vtiger_Block();
        $block->initialize($blockValueMap,$instanceModule);
        try {
            $block->save($instanceModule);
        } catch (Exception $ex) {
            throw new Exception($ex->getMessage());
        }
    }
    
    return $block;
}

function createField($attr,$block)
{
    $fieldInstance = new Vtiger_Field();
    $fieldInstance->name = $attr[0];			              //Usually matches column name
    $fieldInstance->table = $attr[1];
    $fieldInstance->column = $attr[2];		                     //Must be lower case
    $fieldInstance->label = $attr[3];		            //Upper case preceeded by LBL_
    $fieldInstance->columntype = 'TEXT';	    //
    $fieldInstance->uitype = $attr[4];			                   //Multi-Combo picklist
    $fieldInstance->displaytype = 1;
    $fieldInstance->typeofdata = 'V~O';	  //V=Varchar?, M=Mandatory, O=Optional

    if($fieldInstance->uitype == 16)
    {
        $fieldInstance->setPicklistValues($attr[5]);
    }

    $block->addField($fieldInstance);
}

function main()
{
    /** Campo Dealer */

    $dealer = Vtiger_Module::getInstance('Dealer');
    $block1_dealer = createBlock('Segmentacion',$dealer);

    createField(['creantis_idusuario1','vtiger_contactdetails','creantis_idusuario1','ID de Usuario 1','1'],$block1_dealer);
}

main();

