<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouKanbanView license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

include_once 'modules/ITS4YouKanbanView/repositories/KanbanViewRepository.php';

class ITS4YouKanbanView_SaveAjax_Action extends Vtiger_SaveAjax_Action {

    public function checkPermission(Vtiger_Request $request) {
        return true;
    }

    public function process(Vtiger_Request $request) {

        vglobal('VTIGER_TIMESTAMP_NO_CHANGE_MODE', $request->get('_timeStampNoChangeMode',false));
        $recordModel = $this->saveRecord($request);
        vglobal('VTIGER_TIMESTAMP_NO_CHANGE_MODE', false);

        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->setResult(['success' => true]);
        $response->emit();
    }

    /**
     * Function to get the record model based on the request parameters
     * @param Vtiger_Request $request
     * @return Vtiger_Record_Model or Module specific Record Model instance
     */
    public function getRecordModelFromRequest(Vtiger_Request $request) {
        $moduleName = $request->get('source_module');
        $recordId = $request->get('record');

        if (!empty($recordId) && !empty($moduleName)) {
            $recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleName);
            $recordModel->set('id', $recordId);
            $recordModel->set('mode', 'edit');

            $settingFieldModel = ITS4YouKanbanView_KanbanViewRepository_Repository::getSettingFieldModelForModule(getTabid($moduleName));

            $newValue = $request->get('task_picklist_value_name', '');
            if (!empty($newValue)) {
                $recordModel->set($settingFieldModel->getName(), $newValue);
            }
        }

        return $recordModel;
    }
}