<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouKanbanView license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class ITS4YouKanbanView_KanbanViewRepository_Repository
{
    public static function getKanbanViewSettingsForModule($tabId)
    {
        $db = PearDatabase::getInstance();

        $sql = "SELECT * FROM its4you_kanban_view_settings WHERE tabid = ?";
        $result = $db->pquery($sql, array($tabId));

        $row = $db->fetchByAssoc($result, 0);

        $moduleSettingsModel = new ITS4YouKanbanView_ModuleSettings_Model(
            $row['tabid'],
            $row['fieldid'],
            $row['userid'],
            unserialize(htmlspecialchars_decode($row['picklist_values']))
        );

        return $moduleSettingsModel;
    }

    /**
     * @param $tabId
     * @return Vtiger_Field_Model|null
     */
    public static function getSettingFieldModelForModule($tabId)
    {
        $db = PearDatabase::getInstance();

        $sql = "SELECT fieldid FROM its4you_kanban_view_settings WHERE tabid = ?";
        $result = $db->pquery($sql, array($tabId));
        $row = $db->fetchByAssoc($result, 0);

        $fieldModel = null;
        if (!empty($row)) {
            $fieldModel = Vtiger_Field_Model::getInstance($row['fieldid']);
        }

        return $fieldModel;
    }
}