<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouKanbanView license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class ITS4YouKanbanView_AjaxRecordContent_View extends Vtiger_Basic_View
{
    function checkPermission() {
        return true;
    }
    function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);

        $moduleName = $request->get('source_module');
        $recordId = $request->get('record');

        $recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleName);
        $sourceModuleModel = Vtiger_Module_Model::getInstance($moduleName);

        $viewer->assign('RECORD_MODEL', $recordModel);
        $viewer->assign('SOURCE_MODULE_MODEL', $sourceModuleModel);

        $viewer->view('KanbanRecord.tpl', 'ITS4YouKanbanView');
    }
}