<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Potentialfield_getBlocks_Action extends Vtiger_IndexAjax_View {

	public function process(Vtiger_Request $request) {
		global $adb, $site_URL, $PORTAL_URL,$current_user;
        $data = [];
        $TABID = 2;
		$record = $request->get('record');

		$fieldSave = null;
		if(!empty($record))
		{
			$q2 = $adb->pquery("SELECT block FROM vtiger_potentialfield WHERE potentialfieldid = ?",[$record]);
			$fieldSave = decode_html($adb->query_result($q2,0,'block'));
		}

		#$adb->setDebug(true);
        $query = $adb->pquery('SELECT blocklabel, blockid 
								FROM vtiger_blocks
								WHERE tabid = ? 
								ORDER BY sequence ASC',
								[$TABID]);

		if(!empty($adb->num_rows($query)))
		{
			for ($i=0; $i < $adb->num_rows($query); $i++) { 
				$fieldlabel = $adb->query_result($query,$i,'blocklabel');
				$data[$fieldlabel] = decode_html(vtranslate($fieldlabel,'Potentials'));
			}
		}
		#$adb->setDebug(false);
		$response = new Vtiger_Response();
		$response->setResult(array('data' => $data,'selected'=> $fieldSave));
		$response->emit();
	}
}
