<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Potentialfield_getFields_Action extends Vtiger_IndexAjax_View {

	public function process(Vtiger_Request $request) {
		global $adb, $site_URL, $PORTAL_URL,$current_user;
        $data = [];
        $TABID = 2;
		$record = $request->get('record');
		$tipo = $request->get('tipo');
		$campos_excluidos = [	110, 
								115,
								118,
								993, #UTM Source
								995, #UTM Medium
								997, #UTM Campaign
								1128, #Asesor Antiguo
								827 #tags
							];
		
		
		#Obtiene todos el listado de campos que ya han sido configurados
		#$adb->setDebug(true);
		$q = $adb->pquery("SELECT f.fieldid FROM vtiger_potentialfield f JOIN vtiger_crmentity c ON c.crmid = f.potentialfieldid AND c.deleted = 0 WHERE potentialfield_tks_tipodeoportunidad = ?",[$tipo]);
		#$adb->setDebug(false);
		$nQ = $adb->num_rows($q);
		#var_dump($nQ);
		if(!empty($nQ))
		{
			for ($i=0; $i < $nQ; $i++) { 
				$campos_excluidos[] = $adb->query_result($q,$i,'fieldid');
			}
		}

		$fieldSave = null;
		if(!empty($record))
		{
			$q2 = $adb->pquery("SELECT fieldid, potentialfield_tks_campo FROM vtiger_potentialfield WHERE potentialfieldid = ?",[$record]);
			$fieldSave = $adb->query_result($q2,0,'fieldid');
			$fieldLabelSaved = decode_html($adb->query_result($q2,0,'potentialfield_tks_campo'));
			$idx = array_search($fieldSave,$campos_excluidos);
			if(!empty($idx)){
				unset($campos_excluidos[$idx]);
			}
		}

		#$adb->setDebug(true);
        $query = $adb->pquery('SELECT fieldid, columnname, tablename, fieldname, fieldlabel 
								FROM vtiger_field 
								WHERE tabid = ? 
								AND presence IN (0,2) 
								AND displaytype IN (1,3) 
								AND uitype NOT IN (4)
								AND fieldid NOT IN('.implode(',',$campos_excluidos).')
								ORDER BY sequence ASC',
								[$TABID]);

		if(!empty($adb->num_rows($query)))
		{
			for ($i=0; $i < $adb->num_rows($query); $i++) { 
				$fieldname = $adb->query_result($query,$i,'fieldname');
				$fieldid = $adb->query_result($query,$i,'fieldid');
				$fieldlabel = $adb->query_result($query,$i,'fieldlabel');
				$data[$fieldlabel] = decode_html(vtranslate($fieldlabel,'Potentials'));
			}
		}
		#$adb->setDebug(false);
		$response = new Vtiger_Response();
		$response->setResult(array('data' => $data,'selected'=> $fieldLabelSaved));
		$response->emit();
	}
}
