<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Potentials_configList_Action extends Vtiger_IndexAjax_View {

	public function process(Vtiger_Request $request) {
		global $adb, $site_URL, $PORTAL_URL,$current_user;
		
		//Parametros generales
		$MODULE = $request->get('module');

		//Obtenemos los modelos de tipos y subtipos
		$PICKLIST_TIPOBIEN_MODEL = Settings_Picklist_Field_Model::getInstance(1176);
		$PICKLIST_SUBTIPO_MODEL = Settings_Picklist_Field_Model::getInstance(1178);

		//Obtenemos los valore de cada picklist
		$PICKLIST_TIPOBIEN_VALUES = Vtiger_Util_Helper::getPickListValues($PICKLIST_TIPOBIEN_MODEL->getName());
		$PICKLIST_SUBTIPO_VALUES = Vtiger_Util_Helper::getPickListValues($PICKLIST_SUBTIPO_MODEL->getName());
		
		
		// Obtenemos las dependencias
		$SOURCE_FIELD = 'tipodebien'; //Namecampo
		$TARGET_FIELD = 'subtipo';

        $recordModel = Settings_PickListDependency_Record_Model::getInstance($MODULE, $SOURCE_FIELD, $TARGET_FIELD);
        $valueMapping = $recordModel->getPickListDependency();

		//Recorremos para ver cuales fueeron seleccionados
		$RESPONSE = [];

		//Recorremos los tipos
		foreach( $PICKLIST_TIPOBIEN_VALUES as $TIPO ){

			//Lista por dependencia
			$PICKLIST_DEPENDECY =[];
			

			//Buscamos el indice del tipo
			$INDEX_TIPO = array_search($TIPO, array_column($valueMapping, 'sourcevalue'));

			//Recorremos todos los subtipos
			foreach($PICKLIST_SUBTIPO_VALUES as $SUBTIPO ){

				$SUBTIPO_SELECTED = [];
				
				//Buscamos 
				$SUBTIPO_SELECTED['item'] = $SUBTIPO;

				if($INDEX_TIPO === false){
					$SUBTIPO_SELECTED['selected'] = false;
				}
				else
				{
					$INDEX_SUBTIPO = array_search($SUBTIPO,$valueMapping[$INDEX_TIPO]['targetvalues']);

					if($INDEX_SUBTIPO === false){
						$SUBTIPO_SELECTED['selected'] = false;	
					}
					else{
						$SUBTIPO_SELECTED['selected'] = true;	
					}
					
				}

				//Seteamos los parametros				
				$PICKLIST_DEPENDECY[] = $SUBTIPO_SELECTED;
			}
			
			$RESPONSE[$TIPO] = $PICKLIST_DEPENDECY;

		}
		

		$response = new Vtiger_Response();
		$response->setResult(array('success' =>true,'response' => $RESPONSE , 'tipos' => $PICKLIST_TIPOBIEN_VALUES,'test' => $valueMapping));
		$response->emit();

		//var_dump(array('success' => $response, 'micuenta' => $micuenta,'data'=> $asignado));



	}
}
