<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Potentials_getUsersAccounts_Action extends Vtiger_IndexAjax_View {

	public function requiresPermission(\Vtiger_Request $request) {
		$permissions = parent::requiresPermission($request);
		$permissions[] = array('module_parameter' => 'module', 'action' => 'DetailView');
		return $permissions;
	}

	public function process(Vtiger_Request $request) {
		global $adb, $current_customer, $current_user;
		
		$idaccounts = $request->get("idaccount");
		$modelaccount = Vtiger_Record_Model::getInstanceById($idaccounts,"Accounts");
		$assigned_user_id = $modelaccount->get("assigned_user_id");
		$modelUser = Vtiger_Record_Model::getInstanceById($assigned_user_id,"Users");

		$loggedUserModel =  Users_Record_Model::getCurrentUserModel();
		//print_r($modelUser);
		#Guarda la Unidad de la persona asignada - Factoring / Leasing
		$UnidadAsignada = $modelUser->get('opportunity_type');
		$countUnidades = count(explode(" |##| ",$UnidadAsignada ));
		$loggedUserUnity = $loggedUserModel->get('opportunity_type');

	    $response = new Vtiger_Response();
		$response->setResult(array('success'=>true, 'data'=> array('unidad'=>$UnidadAsignada,'n_unidades'=>$countUnidades,'usuarioLogeado_unidad'=>$loggedUserUnity)));
		$response->emit();
	}
}
