<?php
/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

class Potentials_sendTransaccionalData_Action extends Vtiger_IndexAjax_View {

	public function process(Vtiger_Request $request) {
        global $document_root, $current_user;
		
        $record = $request->get('record');
        
        $POTENTIAL = Vtiger_Record_Model::getInstanceById($record,'Potentials');
        $CLIENTE =  Vtiger_Record_Model::getInstanceById($POTENTIAL->get('related_to'),'Accounts');
        $ASIGNED_USER =  Vtiger_Record_Model::getInstanceById($POTENTIAL->get('assigned_user_id'),'Users');
        switch ($POTENTIAL->get('moneda')) {
            case 'Sol': $moneda = 1; break;
            case 'Dolar': $moneda = 2; break;
            default:  $moneda = NULL; break;
        }

        switch ($POTENTIAL->get('opportunity_type')) {
            case 'Descuento': $producto = 1; break;
            case 'Factoring': $producto = 2; break;
            default:  $producto = NULL; break;
        }

        $payload = [
            'cliente' => [
                'ruc' => $CLIENTE->get('siccode'),
                'nombre' => $CLIENTE->get('accountname'),
                'domicilio_legal' => $request->get('bill_street'),
            ],
            'operacion' => [
                'responsable' => $ASIGNED_USER->get("user_name"),
                'email_responsable' => $ASIGNED_USER->get("email1"),
                'moneda' => $moneda,
                'producto' => $producto,
                'linea_solicitada' => str_replace(",","",number_format($POTENTIAL->get('cf_1026'),2))
            ]
        ];

        $contactos = $request->get('contact');
        if(!empty($contactos) && is_array($contactos))
        {
            $nombre = $request->get('nombre');
            $documento = $request->get('documento');
            $email = $request->get('email');
            $telefono = $request->get('telefono');
            foreach($contactos as $k => $id)
            {
                $CONTACTO =  Vtiger_Record_Model::getInstanceById($id,'Contacts');
                $CONTACTO->set('mode','edit');
                $CONTACTO->set('nrodocumento',$documento[$k]);
                $CONTACTO->set('email',$email[$k]);
                $CONTACTO->set('mobile',$telefono[$k]);
                $CONTACTO->save();

                $payload['contactos'][] = [
                    'nombre' => $nombre[$k],
                    'documento'=> $documento[$k],
                    'email' => $email[$k],
                    'telefono' =>$telefono[$k]
                ];
            }
        }
        #echo(json_encode($payload)); die;

        $url = "https://0vbi0d3i41.execute-api.us-east-1.amazonaws.com/qa/oportunidad";
        $cu = curl_init();
		curl_setopt($cu, CURLOPT_URL, $url);
		curl_setopt($cu, CURLOPT_POST, 1);
		curl_setopt($cu, CURLOPT_POSTFIELDS, json_encode($payload));
		curl_setopt($cu, CURLOPT_RETURNTRANSFER, true);
        #curl_setopt($cu, CURLOPT_HEADER, 1);
        #print_r(json_encode($payload)); die;
		$result = curl_exec($cu);
        if(curl_error($cu) != false) $data = 1;
        else{
            $data = 1;
            $rData = json_decode($result,true);
            if(!empty($rData[1]))
            {
                $data = 2;
                $operacion = $rData[1]['operacion'];
                #Actualiza la dirección del cliente con la ingresada en el formulario
                $CLIENTE->set('mode','edit');
                $CLIENTE->set('bill_street',$request->get('bill_street'));
                $CLIENTE->save();
                #Actualiza el Nro de Operación en la Oportunidad
                $POTENTIAL->set('mode','edit');
                $POTENTIAL->set('nro_operacion',$operacion['operacion_id']);
                $POTENTIAL->save();
            }
        } 

        $response = new Vtiger_Response();
		$response->setResult(array('success'=>true, 'data'=> $data));
		$response->emit();
        
        
	}
}
