<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

require_once 'modules/Settings/Picklist/views/IndexAjax.php';

class Potentials_ModalSettingsList_View extends Vtiger_IndexAjax_View {

	public function checkPermission(Vtiger_Request $request) {
	}

	public function process(Vtiger_Request $request) {
		global $adb;




		$viewer = $this->getViewer($request);
		$request->set('source_module','Picklist');
		$request->set('pickListFieldId','8');

		//Picklist normal
		$fieldModel = Settings_Picklist_Field_Model::getInstance(1178);
		$selectedFieldAllPickListValues = Vtiger_Util_Helper::getPickListValues($fieldModel->getName());
		
		$viewer->assign('SELECTED_PICKLIST_FIELDMODEL',$fieldModel);
		$viewer->assign('SELECTED_MODULE_NAME','Potentials');
		$viewer->assign('MODULE','Picklist');
		$viewer->assign('QUALIFIED_MODULE','Settings:Picklist');
        $viewer->assign('ROLES_LIST', Settings_Roles_Record_Model::getAll());
        $viewer->assign('SELECTED_PICKLISTFIELD_ALL_VALUES',$selectedFieldAllPickListValues);

        //Dependecia Picklist
        $module = 'Potentials';
		$sourceField = 'cf_1114';
		$targetField = 'subtipo';
        $recordModel = Settings_PickListDependency_Record_Model::getInstance($module, $sourceField, $targetField);
        $valueMapping = $recordModel->getPickListDependency();
		$sourcePicklistValues = $recordModel->getSourcePickListValues();
		
		$safeHtmlSourcePicklistValues = array();
		foreach($sourcePicklistValues as $key => $value) {
			$safeHtmlSourcePicklistValues[$key] = Vtiger_Util_Helper::toSafeHTML($key);
		}

		$targetPicklistValues = $recordModel->getTargetPickListValues();
		$safeHtmlTargetPicklistValues = array();
		foreach($targetPicklistValues as $key => $value) {
			$safeHtmlTargetPicklistValues[$key] = Vtiger_Util_Helper::toSafeHTML($key);
		}
		
        $viewer->assign('MAPPED_VALUES', $valueMapping);
		$viewer->assign('SOURCE_PICKLIST_VALUES', $sourcePicklistValues);
		$viewer->assign('SAFEHTML_SOURCE_PICKLIST_VALUES', $safeHtmlSourcePicklistValues);
		$viewer->assign('TARGET_PICKLIST_VALUES', $targetPicklistValues);
		$viewer->assign('SAFEHTML_TARGET_PICKLIST_VALUES', $safeHtmlTargetPicklistValues);
		$viewer->assign('QUALIFIED_MODULE', $qualifiedName);
		$viewer->assign('RECORD_MODEL', $recordModel);

		
		$viewer->assign('EXISTE', "1");
		$viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());

		echo $viewer->view('ModalSettingsList.tpl', 'Potentials',true);

	}
	
	public function getHeaderCss(Vtiger_Request $request) {
		$headerCssInstances = parent::getHeaderCss($request);

		$cssFileNames = array(
			'~/libraries/jquery/malihu-custom-scrollbar/css/jquery.mCustomScrollbar.css',
		);
		$cssInstances = $this->checkAndConvertCssStyles($cssFileNames);
		$headerCssInstances = array_merge($headerCssInstances, $cssInstances);

		return $headerCssInstances;
	}

	function getHeaderScripts(Vtiger_Request $request) {
		$headerScriptInstances = parent::getHeaderScripts($request);
		$moduleName = $request->getModule();

		$jsFileNames = array(
			'~libraries/jquery/malihu-custom-scrollbar/js/jquery.mCustomScrollbar.concat.min.js',
		);

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
		return $headerScriptInstances;
	}
    
}