<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouKanbanView license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ITS4YouKanbanView_DeleteAjax_Action extends Settings_Vtiger_Basic_Action
{
    public function __construct() {
        $this->exposeMethod('deleteKanbanSettings');
        parent::__construct();
    }

    function process(Vtiger_Request $request)
    {
        $mode = $request->getMode();
        $this->invokeExposedMethod($mode, $request);
    }

    public function deleteKanbanSettings(Vtiger_Request $request)
    {
        $tabId = $request->get('tabid');
        $fieldId = $request->get('fieldid');

        $response = new Vtiger_Response();

        if (!empty($tabId) && !empty($fieldId)) {
            $settingsModuleModel = new Settings_ITS4YouKanbanView_Module_Model();
            $result = $settingsModuleModel->removeKanbanSettingsByTabIdAndFieldId($tabId, $fieldId);

            if ($result) {
                $settingsModuleModel->removeListViewLink($tabId);
                $response->setResult(array('success' => true));
            } else {
                $response->setError('JS_KANBAN_SETTINGS_NOT_REMOVED');
            }
        } else {
            $response->setError('JS_KANBAN_SETTINGS_NOT_REMOVED_ERROR_IN_PARAMS');
        }

        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->emit();
    }
}