<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouKanbanView license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ITS4YouKanbanView_SaveAjax_Action extends Settings_Vtiger_Basic_Action
{
    public function __construct() {
        $this->exposeMethod('savePicklistValues');
        parent::__construct();
    }

    function process(Vtiger_Request $request)
    {
        $mode = $request->getMode();
        $this->invokeExposedMethod($mode, $request);
    }

    public function savePicklistValues(Vtiger_Request $request)
    {
        $pickListFieldId = $request->get('picklistName');
        $enabledValues = $request->get('enabled_values',array());
        $selectedModule = $request->get('selectedModule');

        $kanbanViewModel = new Settings_ITS4YouKanbanView_Module_Model();

        $response = new Vtiger_Response();
        try {
            $result = $kanbanViewModel->saveDefaultSettings(getTabid($selectedModule), $pickListFieldId, serialize($enabledValues));
            if ($result) {
                $this->addLinkIntoModuleMoreDropdown($selectedModule);
                $response->setResult(array('success' => true));
            } else {
                $response->setError(vtranslate('LBL_SETTINGS_HAVE_NOT_BEEN_SAVED', 'ITS4YouKanbanView'));
            }
        } catch (Exception $e) {
            $response->setError($e->getCode(), $e->getMessage());
        }

        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->emit();
    }

    private function addLinkIntoModuleMoreDropdown($selectedModule)
    {
        $kanbanViewModel = new Settings_ITS4YouKanbanView_Module_Model();
        $kanbanViewModel->createLinkIntoMore(getTabid($selectedModule));

        return true;
    }

    public function validateRequest(Vtiger_Request $request) {
        $request->validateWriteAccess(true);
    }
}