<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouKanbanView license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ITS4YouKanbanView_Module_Model extends Settings_Vtiger_Module_Model
{
    /**
     * Function to get Index view Url
     * @return <String> URL
     */
    public function getEditViewUrl()
    {
        return 'index.php?module=ITS4YouKanbanView&parent=' . $this->getParentName() . '&view=Edit';
    }
    /**
     * @param int $tabId
     * @param int $picklistFieldId
     * @param string $enabledValues
     *
     * @return boolean
     */
    public function saveDefaultSettings($tabId, $picklistFieldId, $enabledValues)
    {
        $db = PearDatabase::getInstance();
        $result = null;

        if (!empty($tabId) && !empty($picklistFieldId)) {

            if (!$this->existSettingsForPicklistField($tabId)) {
                //actually is userId set up to 0
                $userId = 0;

                $sql = "INSERT IGNORE INTO its4you_kanban_view_settings (tabid, fieldid, userid, picklist_values) VALUES (?, ?, ?, ?)";
                $params = [$tabId, $picklistFieldId, $userId, $enabledValues];

                $result = $db->pquery($sql, $params);
            } else {
                $sql = "UPDATE its4you_kanban_view_settings SET picklist_values = ?, fieldid = ? WHERE tabid = ?";
                $params = [$enabledValues, $picklistFieldId, $tabId];

                $result = $db->pquery($sql, $params);
            }

            return $result;
        } else {
            throw new InvalidArgumentException();
        }
    }

    private function existSettingsForPicklistField($tabId)
    {
        $db = PearDatabase::getInstance();

        $sql = "SELECT 1 FROM its4you_kanban_view_settings WHERE tabid = ?";
        $result = $db->pquery($sql, array($tabId));

        return ($db->getRowCount($result) > 0) ? true : false;
    }

    public function getSavedPicklistValues($picklistFieldId, $tabId)
    {
        $db = PearDatabase::getInstance();

        $result = [];

        if (!empty($picklistFieldId) && !empty($tabId)) {
            $sql = "SELECT picklist_values FROM its4you_kanban_view_settings WHERE fieldid = ? AND tabid = ?";
            $params = [$picklistFieldId, $tabId];

            $result = $db->pquery($sql, $params);
            $row = $db->fetchByAssoc($result);

            $result = unserialize(htmlspecialchars_decode($row['picklist_values']));
        }

        return $result;
    }

    public function removeKanbanSettingsByTabIdAndFieldId($tabId, $fieldId)
    {
        $db = PearDatabase::getInstance();

        $sql = "DELETE FROM its4you_kanban_view_settings WHERE tabid = ? AND fieldid = ?";

        $result = $db->pquery($sql, array($tabId, $fieldId));

        return $result;
    }

    /**
     * @return array
     */
    public function getAllSavedSettings()
    {
        $db = PearDatabase::getInstance();

        $result = [];

        $sql = 'SELECT tabid, fieldid FROM its4you_kanban_view_settings';

        $temp = $db->pquery($sql);
        while ($row = $db->fetchByAssoc($temp)) {
            $result[$row['tabid']] = $row['fieldid'];
        }
        unset($temp);

        return $result;
    }

    /**
     * @param int $sourceModuleTabId
     */
    public function createLinkIntoMore($sourceModuleTabId)
    {
        $linkType = 'LISTVIEW';
        $linkLabel = vtranslate('LBL_MODULE_NAME', 'Settings:ITS4YouKanbanView');
        $linkUrl = 'index.php?module=ITS4YouKanbanView&view=List&sourceModule=' . '$MODULE$';

        Vtiger_Link::addLink($sourceModuleTabId, $linkType, $linkLabel, $linkUrl);
    }

    /**
     * @param int $sourceModuleTabId
     */
    public function removeListViewLink($sourceModuleTabId)
    {
        $linkType = 'LISTVIEW';
        $linkLabel = vtranslate('LBL_MODULE_NAME', 'Settings:ITS4YouKanbanView');
        $linkUrl = 'index.php?module=ITS4YouKanbanView&view=List&sourceModule=' . '$MODULE$';

        Vtiger_Link::deleteLink($sourceModuleTabId, $linkType, $linkLabel, $linkUrl);
    }
}