<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouKanbanView license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ITS4YouKanbanView_Edit_View extends Settings_Vtiger_Index_View
{
    public function process(Vtiger_Request $request)
    {
        $sourceModule = $request->get('sourceModule');
        $pickListSupportedModules = Settings_Picklist_Module_Model::getPicklistSupportedModules();

        if(empty($sourceModule)) {
            $sourceModule = $pickListSupportedModules[0]->name;
        }

        $viewer = $this->getViewer($request);
        $qualifiedName = $request->getModule(FALSE);

        $viewer->assign('PICKLIST_MODULES',$pickListSupportedModules);
        $viewer->assign('SELECTED_MODULE_NAME', $sourceModule);
        $viewer->assign('QUALIFIED_NAME',$qualifiedName);

        $viewer->view('Edit.tpl',$qualifiedName);
    }

    function getPageTitle(Vtiger_Request $request) {
        $qualifiedModule = $request->getModule(false);

        return vtranslate('LBL_MODULE_NAME', $qualifiedModule);
    }

    /**
     * Function to get the list of Script models to be included
     * @param Vtiger_Request $request
     * @return <Array> - List of Vtiger_JsScript_Model instances
     */
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            'modules.Vtiger.resources.List',
            'modules.Settings.Vtiger.resources.List',
            "modules.Settings.$moduleName.resources.Edit",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}