<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouKanbanView license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

include_once 'modules/ITS4YouKanbanView/repositories/KanbanViewRepository.php';

class Settings_ITS4YouKanbanView_IndexAjax_View extends Settings_Vtiger_IndexAjax_View
{
    function __construct() {
        parent::__construct();
        $this->exposeMethod('getPickListDetailsForModule');
        $this->exposeMethod('getPickListValueForField');
        $this->exposeMethod('getPickListValueByRole');
    }

    public function process(Vtiger_Request $request) {
        $mode = $request->get('mode');
        if($this->isMethodExposed($mode)) {
            $this->invokeExposedMethod($mode, $request);
        }
    }

    public function getPickListDetailsForModule(Vtiger_Request $request) {
        $sourceModule = $request->get('source_module');
        $qualifiedName = $request->getModule(false);

        $moduleModel = Settings_Picklist_Module_Model::getInstance($sourceModule);
        $pickListFields = $moduleModel->getFieldsByType(array('picklist','multipicklist'));

        $savedField = ITS4YouKanbanView_KanbanViewRepository_Repository::getSettingFieldModelForModule(getTabid($sourceModule));

        $viewer = $this->getViewer($request);
        $viewer->assign('PICKLIST_FIELDS',$pickListFields);
        $viewer->assign('SAVED_FIELD', $savedField);
        $viewer->assign('SELECTED_MODULE_NAME',$sourceModule);
        $viewer->assign('QUALIFIED_MODULE',$qualifiedName);
        $viewer->view('ModulePickListDetail.tpl',$qualifiedName);
    }

    public function getPickListValueForField(Vtiger_Request $request) {
        $sourceModule = $request->get('source_module');
        $qualifiedName = $request->getModule(false);
        $pickFieldId = $request->get('pickListFieldId');

        $fieldModel = Settings_Picklist_Field_Model::getInstance($pickFieldId);
        $moduleName = $request->getModule();

        $allPickListValues = Vtiger_Util_Helper::getPickListValues($fieldModel->getName());
        $allPickListValues =  array_map('Vtiger_Util_Helper::toSafeHTML', $allPickListValues);

        $kanbanViewModel = new Settings_ITS4YouKanbanView_Module_Model();
        $savedPicklistValues = $kanbanViewModel->getSavedPicklistValues($fieldModel->getId(), getTabid($sourceModule));

        $viewer = $this->getViewer($request);
        $viewer->assign('SELECTED_PICKLIST_FIELDMODEL',$fieldModel);
        $viewer->assign('SELECTED_MODULE_NAME',$sourceModule);
        $viewer->assign('MODULE',$moduleName);
        $viewer->assign('QUALIFIED_MODULE',$qualifiedName);
        $viewer->assign('ALL_PICKLIST_VALUES', $allPickListValues);
        $viewer->assign("SAVED_PICKLIST_VALUES", $savedPicklistValues);
        $viewer->view('PickListValueDetail.tpl',$qualifiedName);
    }
}