<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Vtiger_GetUsers_Action extends Vtiger_IndexAjax_View {

	public function requiresPermission(\Vtiger_Request $request) {
		$permissions = parent::requiresPermission($request);
		$permissions[] = array('module_parameter' => 'source_module', 'action' => 'DetailView', 'record_parameter' => 'record');
		return $permissions;
	}

	public function process(Vtiger_Request $request) {
		$field_asignar_a = 'cf_1001';
		$sourceModule = $request->get('source_module');
		$record = $request->get('record');
		$response = new Vtiger_Response();

		global $adb;
		$rs = $adb->pquery("SELECT u.id, u.first_name, u.last_name, r.rolename 
				FROM vtiger_users u 
				inner join vtiger_user2role ur on u.id= ur.userid
				inner join vtiger_role r on ur.roleid = r.roleid
				where u.deleted = 0 and u.status = 'Active'");
		$users = array();
		while ($row = $adb->fetch_row($rs)) {
			$users[] = array_map("decode_html", $row);
		}

		$asignados = array();
		if ( !empty($record) ) {
			$model = Vtiger_Record_Model::getInstanceById($record, 'Campaigns');
			$asignados = decode_html($model->get($field_asignar_a));
		}

		$response->setResult(array('success'=>true, 'users'=> $users, 'asignados' => $asignados));
		$response->emit();
	}
}
